/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHashAlgorithmType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvHashAlgorithm;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnHashAlgorithmTypeSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvHashAlgorithmVer15
implements OFBsnTlvHashAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvHashAlgorithmVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private final OFBsnHashAlgorithmType value;
    static final Reader READER = new Reader();
    static final OFBsnTlvHashAlgorithmVer15Funnel FUNNEL = new OFBsnTlvHashAlgorithmVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvHashAlgorithmVer15(OFBsnHashAlgorithmType value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvHashAlgorithmVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 145;
    }

    @Override
    public OFBsnHashAlgorithmType getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvHashAlgorithm.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvHashAlgorithmVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvHashAlgorithmVer15 other = (OFBsnTlvHashAlgorithmVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvHashAlgorithmVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvHashAlgorithmVer15 message) {
            bb.writeShort(145);
            bb.writeShort(6);
            OFBsnHashAlgorithmTypeSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvHashAlgorithmVer15Funnel
    implements Funnel<OFBsnTlvHashAlgorithmVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvHashAlgorithmVer15Funnel() {
        }

        public void funnel(OFBsnTlvHashAlgorithmVer15 message, PrimitiveSink sink) {
            sink.putShort((short)145);
            sink.putShort((short)6);
            OFBsnHashAlgorithmTypeSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvHashAlgorithm> {
        Reader() {
        }

        @Override
        public OFBsnTlvHashAlgorithm readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 145) {
                throw new OFParseError("Wrong type: Expected=0x91(0x91), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnHashAlgorithmType value = OFBsnHashAlgorithmTypeSerializerVer15.readFrom(bb);
            OFBsnTlvHashAlgorithmVer15 bsnTlvHashAlgorithmVer15 = new OFBsnTlvHashAlgorithmVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvHashAlgorithmVer15);
            }
            return bsnTlvHashAlgorithmVer15;
        }
    }

    static class Builder
    implements OFBsnTlvHashAlgorithm.Builder {
        private boolean valueSet;
        private OFBsnHashAlgorithmType value;

        Builder() {
        }

        @Override
        public int getType() {
            return 145;
        }

        @Override
        public OFBsnHashAlgorithmType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHashAlgorithm.Builder setValue(OFBsnHashAlgorithmType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvHashAlgorithm build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvHashAlgorithmVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvHashAlgorithm.Builder {
        final OFBsnTlvHashAlgorithmVer15 parentMessage;
        private boolean valueSet;
        private OFBsnHashAlgorithmType value;

        BuilderWithParent(OFBsnTlvHashAlgorithmVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 145;
        }

        @Override
        public OFBsnHashAlgorithmType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHashAlgorithm.Builder setValue(OFBsnHashAlgorithmType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvHashAlgorithm build() {
            OFBsnHashAlgorithmType value;
            OFBsnHashAlgorithmType oFBsnHashAlgorithmType = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvHashAlgorithmVer15(value);
        }
    }
}

