/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnSetLacpRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnSetLacpRequestVer15
implements OFBsnSetLacpRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnSetLacpRequestVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 38;
    private static final long DEFAULT_XID = 0L;
    private static final short DEFAULT_ENABLED = 0;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final int DEFAULT_ACTOR_SYS_PRIORITY = 0;
    private static final MacAddress DEFAULT_ACTOR_SYS_MAC = MacAddress.NONE;
    private static final int DEFAULT_ACTOR_PORT_PRIORITY = 0;
    private static final int DEFAULT_ACTOR_PORT_NUM = 0;
    private static final int DEFAULT_ACTOR_KEY = 0;
    private final long xid;
    private final short enabled;
    private final OFPort portNo;
    private final int actorSysPriority;
    private final MacAddress actorSysMac;
    private final int actorPortPriority;
    private final int actorPortNum;
    private final int actorKey;
    static final OFBsnSetLacpRequestVer15 DEFAULT = new OFBsnSetLacpRequestVer15(0L, 0, DEFAULT_PORT_NO, 0, DEFAULT_ACTOR_SYS_MAC, 0, 0, 0);
    static final Reader READER = new Reader();
    static final OFBsnSetLacpRequestVer15Funnel FUNNEL = new OFBsnSetLacpRequestVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnSetLacpRequestVer15(long xid, short enabled, OFPort portNo, int actorSysPriority, MacAddress actorSysMac, int actorPortPriority, int actorPortNum, int actorKey) {
        if (portNo == null) {
            throw new NullPointerException("OFBsnSetLacpRequestVer15: property portNo cannot be null");
        }
        if (actorSysMac == null) {
            throw new NullPointerException("OFBsnSetLacpRequestVer15: property actorSysMac cannot be null");
        }
        this.xid = xid;
        this.enabled = enabled;
        this.portNo = portNo;
        this.actorSysPriority = actorSysPriority;
        this.actorSysMac = actorSysMac;
        this.actorPortPriority = actorPortPriority;
        this.actorPortNum = actorPortNum;
        this.actorKey = actorKey;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 41L;
    }

    @Override
    public short getEnabled() {
        return this.enabled;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public int getActorSysPriority() {
        return this.actorSysPriority;
    }

    @Override
    public MacAddress getActorSysMac() {
        return this.actorSysMac;
    }

    @Override
    public int getActorPortPriority() {
        return this.actorPortPriority;
    }

    @Override
    public int getActorPortNum() {
        return this.actorPortNum;
    }

    @Override
    public int getActorKey() {
        return this.actorKey;
    }

    @Override
    public OFBsnSetLacpRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnSetLacpRequestVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("enabled=").append(this.enabled);
        b.append(", ");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("actorSysPriority=").append(this.actorSysPriority);
        b.append(", ");
        b.append("actorSysMac=").append(this.actorSysMac);
        b.append(", ");
        b.append("actorPortPriority=").append(this.actorPortPriority);
        b.append(", ");
        b.append("actorPortNum=").append(this.actorPortNum);
        b.append(", ");
        b.append("actorKey=").append(this.actorKey);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSetLacpRequestVer15 other = (OFBsnSetLacpRequestVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.actorSysPriority != other.actorSysPriority) {
            return false;
        }
        if (this.actorSysMac == null ? other.actorSysMac != null : !this.actorSysMac.equals(other.actorSysMac)) {
            return false;
        }
        if (this.actorPortPriority != other.actorPortPriority) {
            return false;
        }
        if (this.actorPortNum != other.actorPortNum) {
            return false;
        }
        return this.actorKey == other.actorKey;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSetLacpRequestVer15 other = (OFBsnSetLacpRequestVer15)obj;
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.actorSysPriority != other.actorSysPriority) {
            return false;
        }
        if (this.actorSysMac == null ? other.actorSysMac != null : !this.actorSysMac.equals(other.actorSysMac)) {
            return false;
        }
        if (this.actorPortPriority != other.actorPortPriority) {
            return false;
        }
        if (this.actorPortNum != other.actorPortNum) {
            return false;
        }
        return this.actorKey == other.actorKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + this.enabled;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + this.actorSysPriority;
        result = 31 * result + (this.actorSysMac == null ? 0 : this.actorSysMac.hashCode());
        result = 31 * result + this.actorPortPriority;
        result = 31 * result + this.actorPortNum;
        result = 31 * result + this.actorKey;
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.enabled;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + this.actorSysPriority;
        result = 31 * result + (this.actorSysMac == null ? 0 : this.actorSysMac.hashCode());
        result = 31 * result + this.actorPortPriority;
        result = 31 * result + this.actorPortNum;
        result = 31 * result + this.actorKey;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnSetLacpRequestVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnSetLacpRequestVer15 message) {
            bb.writeByte(6);
            bb.writeByte(4);
            bb.writeShort(38);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(41);
            bb.writeByte((int)U8.t(message.enabled));
            bb.writeZero(3);
            message.portNo.write4Bytes(bb);
            bb.writeShort((int)U16.t(message.actorSysPriority));
            message.actorSysMac.write6Bytes(bb);
            bb.writeShort((int)U16.t(message.actorPortPriority));
            bb.writeShort((int)U16.t(message.actorPortNum));
            bb.writeShort((int)U16.t(message.actorKey));
        }
    }

    static class OFBsnSetLacpRequestVer15Funnel
    implements Funnel<OFBsnSetLacpRequestVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnSetLacpRequestVer15Funnel() {
        }

        public void funnel(OFBsnSetLacpRequestVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)4);
            sink.putShort((short)38);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(41);
            sink.putShort(message.enabled);
            message.portNo.putTo(sink);
            sink.putInt(message.actorSysPriority);
            message.actorSysMac.putTo(sink);
            sink.putInt(message.actorPortPriority);
            sink.putInt(message.actorPortNum);
            sink.putInt(message.actorKey);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnSetLacpRequest> {
        Reader() {
        }

        @Override
        public OFBsnSetLacpRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 38) {
                throw new OFParseError("Wrong length: Expected=38(38), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 41) {
                throw new OFParseError("Wrong subtype: Expected=0x29L(0x29L), got=" + subtype);
            }
            short enabled = U8.f(bb.readByte());
            bb.skipBytes(3);
            OFPort portNo = OFPort.read4Bytes(bb);
            int actorSysPriority = U16.f(bb.readShort());
            MacAddress actorSysMac = MacAddress.read6Bytes(bb);
            int actorPortPriority = U16.f(bb.readShort());
            int actorPortNum = U16.f(bb.readShort());
            int actorKey = U16.f(bb.readShort());
            OFBsnSetLacpRequestVer15 bsnSetLacpRequestVer15 = new OFBsnSetLacpRequestVer15(xid, enabled, portNo, actorSysPriority, actorSysMac, actorPortPriority, actorPortNum, actorKey);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnSetLacpRequestVer15);
            }
            return bsnSetLacpRequestVer15;
        }
    }

    static class Builder
    implements OFBsnSetLacpRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean enabledSet;
        private short enabled;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean actorSysPrioritySet;
        private int actorSysPriority;
        private boolean actorSysMacSet;
        private MacAddress actorSysMac;
        private boolean actorPortPrioritySet;
        private int actorPortPriority;
        private boolean actorPortNumSet;
        private int actorPortNum;
        private boolean actorKeySet;
        private int actorKey;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSetLacpRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 41L;
        }

        @Override
        public short getEnabled() {
            return this.enabled;
        }

        @Override
        public OFBsnSetLacpRequest.Builder setEnabled(short enabled) {
            this.enabled = enabled;
            this.enabledSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnSetLacpRequest.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public int getActorSysPriority() {
            return this.actorSysPriority;
        }

        @Override
        public OFBsnSetLacpRequest.Builder setActorSysPriority(int actorSysPriority) {
            this.actorSysPriority = actorSysPriority;
            this.actorSysPrioritySet = true;
            return this;
        }

        @Override
        public MacAddress getActorSysMac() {
            return this.actorSysMac;
        }

        @Override
        public OFBsnSetLacpRequest.Builder setActorSysMac(MacAddress actorSysMac) {
            this.actorSysMac = actorSysMac;
            this.actorSysMacSet = true;
            return this;
        }

        @Override
        public int getActorPortPriority() {
            return this.actorPortPriority;
        }

        @Override
        public OFBsnSetLacpRequest.Builder setActorPortPriority(int actorPortPriority) {
            this.actorPortPriority = actorPortPriority;
            this.actorPortPrioritySet = true;
            return this;
        }

        @Override
        public int getActorPortNum() {
            return this.actorPortNum;
        }

        @Override
        public OFBsnSetLacpRequest.Builder setActorPortNum(int actorPortNum) {
            this.actorPortNum = actorPortNum;
            this.actorPortNumSet = true;
            return this;
        }

        @Override
        public int getActorKey() {
            return this.actorKey;
        }

        @Override
        public OFBsnSetLacpRequest.Builder setActorKey(int actorKey) {
            this.actorKey = actorKey;
            this.actorKeySet = true;
            return this;
        }

        @Override
        public OFBsnSetLacpRequest build() {
            MacAddress actorSysMac;
            OFPort portNo;
            long xid = this.xidSet ? this.xid : 0L;
            short enabled = this.enabledSet ? this.enabled : (short)0;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            int actorSysPriority = this.actorSysPrioritySet ? this.actorSysPriority : 0;
            MacAddress macAddress = actorSysMac = this.actorSysMacSet ? this.actorSysMac : DEFAULT_ACTOR_SYS_MAC;
            if (actorSysMac == null) {
                throw new NullPointerException("Property actorSysMac must not be null");
            }
            int actorPortPriority = this.actorPortPrioritySet ? this.actorPortPriority : 0;
            int actorPortNum = this.actorPortNumSet ? this.actorPortNum : 0;
            int actorKey = this.actorKeySet ? this.actorKey : 0;
            return new OFBsnSetLacpRequestVer15(xid, enabled, portNo, actorSysPriority, actorSysMac, actorPortPriority, actorPortNum, actorKey);
        }
    }

    static class BuilderWithParent
    implements OFBsnSetLacpRequest.Builder {
        final OFBsnSetLacpRequestVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean enabledSet;
        private short enabled;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean actorSysPrioritySet;
        private int actorSysPriority;
        private boolean actorSysMacSet;
        private MacAddress actorSysMac;
        private boolean actorPortPrioritySet;
        private int actorPortPriority;
        private boolean actorPortNumSet;
        private int actorPortNum;
        private boolean actorKeySet;
        private int actorKey;

        BuilderWithParent(OFBsnSetLacpRequestVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSetLacpRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 41L;
        }

        @Override
        public short getEnabled() {
            return this.enabled;
        }

        @Override
        public OFBsnSetLacpRequest.Builder setEnabled(short enabled) {
            this.enabled = enabled;
            this.enabledSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnSetLacpRequest.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public int getActorSysPriority() {
            return this.actorSysPriority;
        }

        @Override
        public OFBsnSetLacpRequest.Builder setActorSysPriority(int actorSysPriority) {
            this.actorSysPriority = actorSysPriority;
            this.actorSysPrioritySet = true;
            return this;
        }

        @Override
        public MacAddress getActorSysMac() {
            return this.actorSysMac;
        }

        @Override
        public OFBsnSetLacpRequest.Builder setActorSysMac(MacAddress actorSysMac) {
            this.actorSysMac = actorSysMac;
            this.actorSysMacSet = true;
            return this;
        }

        @Override
        public int getActorPortPriority() {
            return this.actorPortPriority;
        }

        @Override
        public OFBsnSetLacpRequest.Builder setActorPortPriority(int actorPortPriority) {
            this.actorPortPriority = actorPortPriority;
            this.actorPortPrioritySet = true;
            return this;
        }

        @Override
        public int getActorPortNum() {
            return this.actorPortNum;
        }

        @Override
        public OFBsnSetLacpRequest.Builder setActorPortNum(int actorPortNum) {
            this.actorPortNum = actorPortNum;
            this.actorPortNumSet = true;
            return this;
        }

        @Override
        public int getActorKey() {
            return this.actorKey;
        }

        @Override
        public OFBsnSetLacpRequest.Builder setActorKey(int actorKey) {
            this.actorKey = actorKey;
            this.actorKeySet = true;
            return this;
        }

        @Override
        public OFBsnSetLacpRequest build() {
            MacAddress actorSysMac;
            OFPort portNo;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            short enabled = this.enabledSet ? this.enabled : this.parentMessage.enabled;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            int actorSysPriority = this.actorSysPrioritySet ? this.actorSysPriority : this.parentMessage.actorSysPriority;
            MacAddress macAddress = actorSysMac = this.actorSysMacSet ? this.actorSysMac : this.parentMessage.actorSysMac;
            if (actorSysMac == null) {
                throw new NullPointerException("Property actorSysMac must not be null");
            }
            int actorPortPriority = this.actorPortPrioritySet ? this.actorPortPriority : this.parentMessage.actorPortPriority;
            int actorPortNum = this.actorPortNumSet ? this.actorPortNum : this.parentMessage.actorPortNum;
            int actorKey = this.actorKeySet ? this.actorKey : this.parentMessage.actorKey;
            return new OFBsnSetLacpRequestVer15(xid, enabled, portNo, actorSysPriority, actorSysMac, actorPortPriority, actorPortNum, actorKey);
        }
    }
}

