/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnLuaCommandReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnLuaCommandReplyVer15
implements OFBsnLuaCommandReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnLuaCommandReplyVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final byte[] DEFAULT_DATA = new byte[0];
    private final long xid;
    private final byte[] data;
    static final OFBsnLuaCommandReplyVer15 DEFAULT = new OFBsnLuaCommandReplyVer15(0L, DEFAULT_DATA);
    static final Reader READER = new Reader();
    static final OFBsnLuaCommandReplyVer15Funnel FUNNEL = new OFBsnLuaCommandReplyVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnLuaCommandReplyVer15(long xid, byte[] data) {
        if (data == null) {
            throw new NullPointerException("OFBsnLuaCommandReplyVer15: property data cannot be null");
        }
        this.xid = xid;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 66L;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public OFBsnLuaCommandReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnLuaCommandReplyVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("data=").append(Arrays.toString(this.data));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnLuaCommandReplyVer15 other = (OFBsnLuaCommandReplyVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnLuaCommandReplyVer15 other = (OFBsnLuaCommandReplyVer15)obj;
        return Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnLuaCommandReplyVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnLuaCommandReplyVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(66);
            bb.writeBytes(message.data);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnLuaCommandReplyVer15Funnel
    implements Funnel<OFBsnLuaCommandReplyVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnLuaCommandReplyVer15Funnel() {
        }

        public void funnel(OFBsnLuaCommandReplyVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)4);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(66);
            sink.putBytes(message.data);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnLuaCommandReply> {
        Reader() {
        }

        @Override
        public OFBsnLuaCommandReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 66) {
                throw new OFParseError("Wrong subtype: Expected=0x42L(0x42L), got=" + subtype);
            }
            byte[] data = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFBsnLuaCommandReplyVer15 bsnLuaCommandReplyVer15 = new OFBsnLuaCommandReplyVer15(xid, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnLuaCommandReplyVer15);
            }
            return bsnLuaCommandReplyVer15;
        }
    }

    static class Builder
    implements OFBsnLuaCommandReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean dataSet;
        private byte[] data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnLuaCommandReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 66L;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFBsnLuaCommandReply.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnLuaCommandReply build() {
            byte[] data;
            long xid = this.xidSet ? this.xid : 0L;
            byte[] byArray = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnLuaCommandReplyVer15(xid, data);
        }
    }

    static class BuilderWithParent
    implements OFBsnLuaCommandReply.Builder {
        final OFBsnLuaCommandReplyVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean dataSet;
        private byte[] data;

        BuilderWithParent(OFBsnLuaCommandReplyVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnLuaCommandReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 66L;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFBsnLuaCommandReply.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnLuaCommandReply build() {
            byte[] data;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            byte[] byArray = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnLuaCommandReplyVer15(xid, data);
        }
    }
}

