/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnDebugCounterStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFStatsRequestFlagsSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnDebugCounterStatsRequestVer15
implements OFBsnDebugCounterStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnDebugCounterStatsRequestVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    static final OFBsnDebugCounterStatsRequestVer15 DEFAULT = new OFBsnDebugCounterStatsRequestVer15(0L, DEFAULT_FLAGS);
    static final Reader READER = new Reader();
    static final OFBsnDebugCounterStatsRequestVer15Funnel FUNNEL = new OFBsnDebugCounterStatsRequestVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnDebugCounterStatsRequestVer15(long xid, Set<OFStatsRequestFlags> flags) {
        if (flags == null) {
            throw new NullPointerException("OFBsnDebugCounterStatsRequestVer15: property flags cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 12L;
    }

    @Override
    public OFBsnDebugCounterStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnDebugCounterStatsRequestVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnDebugCounterStatsRequestVer15 other = (OFBsnDebugCounterStatsRequestVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.flags == null ? other.flags != null : !this.flags.equals(other.flags));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnDebugCounterStatsRequestVer15 other = (OFBsnDebugCounterStatsRequestVer15)obj;
        return !(this.flags == null ? other.flags != null : !this.flags.equals(other.flags));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnDebugCounterStatsRequestVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnDebugCounterStatsRequestVer15 message) {
            bb.writeByte(6);
            bb.writeByte(18);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            OFStatsRequestFlagsSerializerVer15.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(6035143);
            bb.writeInt(12);
        }
    }

    static class OFBsnDebugCounterStatsRequestVer15Funnel
    implements Funnel<OFBsnDebugCounterStatsRequestVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnDebugCounterStatsRequestVer15Funnel() {
        }

        public void funnel(OFBsnDebugCounterStatsRequestVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)18);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            OFStatsRequestFlagsSerializerVer15.putTo(message.flags, sink);
            sink.putInt(6035143);
            sink.putInt(12);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnDebugCounterStatsRequest> {
        Reader() {
        }

        @Override
        public OFBsnDebugCounterStatsRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer15.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 12) {
                throw new OFParseError("Wrong subtype: Expected=0xcL(0xcL), got=" + subtype);
            }
            OFBsnDebugCounterStatsRequestVer15 bsnDebugCounterStatsRequestVer15 = new OFBsnDebugCounterStatsRequestVer15(xid, flags);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnDebugCounterStatsRequestVer15);
            }
            return bsnDebugCounterStatsRequestVer15;
        }
    }

    static class Builder
    implements OFBsnDebugCounterStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnDebugCounterStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnDebugCounterStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 12L;
        }

        @Override
        public OFBsnDebugCounterStatsRequest build() {
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFBsnDebugCounterStatsRequestVer15(xid, flags);
        }
    }

    static class BuilderWithParent
    implements OFBsnDebugCounterStatsRequest.Builder {
        final OFBsnDebugCounterStatsRequestVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;

        BuilderWithParent(OFBsnDebugCounterStatsRequestVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnDebugCounterStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnDebugCounterStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 12L;
        }

        @Override
        public OFBsnDebugCounterStatsRequest build() {
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFBsnDebugCounterStatsRequestVer15(xid, flags);
        }
    }
}

