/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnControllerConnection;
import org.projectfloodlight.openflow.protocol.OFBsnControllerConnectionState;
import org.projectfloodlight.openflow.protocol.OFControllerRole;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnControllerConnectionStateSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFControllerRoleSerializerVer15;
import org.projectfloodlight.openflow.types.OFAuxId;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnControllerConnectionVer15
implements OFBsnControllerConnection {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnControllerConnectionVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 264;
    private static final OFAuxId DEFAULT_AUXILIARY_ID = OFAuxId.MAIN;
    private static final String DEFAULT_URI = "";
    private final OFBsnControllerConnectionState state;
    private final OFAuxId auxiliaryId;
    private final OFControllerRole role;
    private final String uri;
    static final Reader READER = new Reader();
    static final OFBsnControllerConnectionVer15Funnel FUNNEL = new OFBsnControllerConnectionVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnControllerConnectionVer15(OFBsnControllerConnectionState state, OFAuxId auxiliaryId, OFControllerRole role, String uri) {
        if (state == null) {
            throw new NullPointerException("OFBsnControllerConnectionVer15: property state cannot be null");
        }
        if (auxiliaryId == null) {
            throw new NullPointerException("OFBsnControllerConnectionVer15: property auxiliaryId cannot be null");
        }
        if (role == null) {
            throw new NullPointerException("OFBsnControllerConnectionVer15: property role cannot be null");
        }
        if (uri == null) {
            throw new NullPointerException("OFBsnControllerConnectionVer15: property uri cannot be null");
        }
        this.state = state;
        this.auxiliaryId = auxiliaryId;
        this.role = role;
        this.uri = uri;
    }

    @Override
    public OFBsnControllerConnectionState getState() {
        return this.state;
    }

    @Override
    public OFAuxId getAuxiliaryId() {
        return this.auxiliaryId;
    }

    @Override
    public OFControllerRole getRole() {
        return this.role;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnControllerConnection.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnControllerConnectionVer15(");
        b.append("state=").append((Object)this.state);
        b.append(", ");
        b.append("auxiliaryId=").append(this.auxiliaryId);
        b.append(", ");
        b.append("role=").append((Object)this.role);
        b.append(", ");
        b.append("uri=").append(this.uri);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnControllerConnectionVer15 other = (OFBsnControllerConnectionVer15)obj;
        if (this.state == null ? other.state != null : !this.state.equals((Object)other.state)) {
            return false;
        }
        if (this.auxiliaryId == null ? other.auxiliaryId != null : !this.auxiliaryId.equals(other.auxiliaryId)) {
            return false;
        }
        if (this.role == null ? other.role != null : !this.role.equals((Object)other.role)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.auxiliaryId == null ? 0 : this.auxiliaryId.hashCode());
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnControllerConnectionVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnControllerConnectionVer15 message) {
            OFBsnControllerConnectionStateSerializerVer15.writeTo(bb, message.state);
            message.auxiliaryId.writeByte(bb);
            bb.writeZero(2);
            OFControllerRoleSerializerVer15.writeTo(bb, message.role);
            ChannelUtils.writeFixedLengthString(bb, message.uri, 256);
        }
    }

    static class OFBsnControllerConnectionVer15Funnel
    implements Funnel<OFBsnControllerConnectionVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnControllerConnectionVer15Funnel() {
        }

        public void funnel(OFBsnControllerConnectionVer15 message, PrimitiveSink sink) {
            OFBsnControllerConnectionStateSerializerVer15.putTo(message.state, sink);
            message.auxiliaryId.putTo(sink);
            OFControllerRoleSerializerVer15.putTo(message.role, sink);
            sink.putUnencodedChars((CharSequence)message.uri);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnControllerConnection> {
        Reader() {
        }

        @Override
        public OFBsnControllerConnection readFrom(ByteBuf bb) throws OFParseError {
            OFBsnControllerConnectionState state = OFBsnControllerConnectionStateSerializerVer15.readFrom(bb);
            OFAuxId auxiliaryId = OFAuxId.readByte(bb);
            bb.skipBytes(2);
            OFControllerRole role = OFControllerRoleSerializerVer15.readFrom(bb);
            String uri = ChannelUtils.readFixedLengthString(bb, 256);
            OFBsnControllerConnectionVer15 bsnControllerConnectionVer15 = new OFBsnControllerConnectionVer15(state, auxiliaryId, role, uri);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnControllerConnectionVer15);
            }
            return bsnControllerConnectionVer15;
        }
    }

    static class Builder
    implements OFBsnControllerConnection.Builder {
        private boolean stateSet;
        private OFBsnControllerConnectionState state;
        private boolean auxiliaryIdSet;
        private OFAuxId auxiliaryId;
        private boolean roleSet;
        private OFControllerRole role;
        private boolean uriSet;
        private String uri;

        Builder() {
        }

        @Override
        public OFBsnControllerConnectionState getState() {
            return this.state;
        }

        @Override
        public OFBsnControllerConnection.Builder setState(OFBsnControllerConnectionState state) {
            this.state = state;
            this.stateSet = true;
            return this;
        }

        @Override
        public OFAuxId getAuxiliaryId() {
            return this.auxiliaryId;
        }

        @Override
        public OFBsnControllerConnection.Builder setAuxiliaryId(OFAuxId auxiliaryId) {
            this.auxiliaryId = auxiliaryId;
            this.auxiliaryIdSet = true;
            return this;
        }

        @Override
        public OFControllerRole getRole() {
            return this.role;
        }

        @Override
        public OFBsnControllerConnection.Builder setRole(OFControllerRole role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public String getUri() {
            return this.uri;
        }

        @Override
        public OFBsnControllerConnection.Builder setUri(String uri) {
            this.uri = uri;
            this.uriSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnControllerConnection build() {
            String uri;
            OFAuxId auxiliaryId;
            if (!this.stateSet) {
                throw new IllegalStateException("Property state doesn't have default value -- must be set");
            }
            if (this.state == null) {
                throw new NullPointerException("Property state must not be null");
            }
            OFAuxId oFAuxId = auxiliaryId = this.auxiliaryIdSet ? this.auxiliaryId : DEFAULT_AUXILIARY_ID;
            if (auxiliaryId == null) {
                throw new NullPointerException("Property auxiliaryId must not be null");
            }
            if (!this.roleSet) {
                throw new IllegalStateException("Property role doesn't have default value -- must be set");
            }
            if (this.role == null) {
                throw new NullPointerException("Property role must not be null");
            }
            String string = uri = this.uriSet ? this.uri : OFBsnControllerConnectionVer15.DEFAULT_URI;
            if (uri == null) {
                throw new NullPointerException("Property uri must not be null");
            }
            return new OFBsnControllerConnectionVer15(this.state, auxiliaryId, this.role, uri);
        }
    }

    static class BuilderWithParent
    implements OFBsnControllerConnection.Builder {
        final OFBsnControllerConnectionVer15 parentMessage;
        private boolean stateSet;
        private OFBsnControllerConnectionState state;
        private boolean auxiliaryIdSet;
        private OFAuxId auxiliaryId;
        private boolean roleSet;
        private OFControllerRole role;
        private boolean uriSet;
        private String uri;

        BuilderWithParent(OFBsnControllerConnectionVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFBsnControllerConnectionState getState() {
            return this.state;
        }

        @Override
        public OFBsnControllerConnection.Builder setState(OFBsnControllerConnectionState state) {
            this.state = state;
            this.stateSet = true;
            return this;
        }

        @Override
        public OFAuxId getAuxiliaryId() {
            return this.auxiliaryId;
        }

        @Override
        public OFBsnControllerConnection.Builder setAuxiliaryId(OFAuxId auxiliaryId) {
            this.auxiliaryId = auxiliaryId;
            this.auxiliaryIdSet = true;
            return this;
        }

        @Override
        public OFControllerRole getRole() {
            return this.role;
        }

        @Override
        public OFBsnControllerConnection.Builder setRole(OFControllerRole role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public String getUri() {
            return this.uri;
        }

        @Override
        public OFBsnControllerConnection.Builder setUri(String uri) {
            this.uri = uri;
            this.uriSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnControllerConnection build() {
            String uri;
            OFControllerRole role;
            OFAuxId auxiliaryId;
            OFBsnControllerConnectionState state;
            OFBsnControllerConnectionState oFBsnControllerConnectionState = state = this.stateSet ? this.state : this.parentMessage.state;
            if (state == null) {
                throw new NullPointerException("Property state must not be null");
            }
            OFAuxId oFAuxId = auxiliaryId = this.auxiliaryIdSet ? this.auxiliaryId : this.parentMessage.auxiliaryId;
            if (auxiliaryId == null) {
                throw new NullPointerException("Property auxiliaryId must not be null");
            }
            OFControllerRole oFControllerRole = role = this.roleSet ? this.role : this.parentMessage.role;
            if (role == null) {
                throw new NullPointerException("Property role must not be null");
            }
            String string = uri = this.uriSet ? this.uri : this.parentMessage.uri;
            if (uri == null) {
                throw new NullPointerException("Property uri must not be null");
            }
            return new OFBsnControllerConnectionVer15(state, auxiliaryId, role, uri);
        }
    }
}

