/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncConfigPropPortStatusSlave;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncConfigPropPortStatusSlaveVer15
implements OFAsyncConfigPropPortStatusSlave {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncConfigPropPortStatusSlaveVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_MASK = 0L;
    private final long mask;
    static final OFAsyncConfigPropPortStatusSlaveVer15 DEFAULT = new OFAsyncConfigPropPortStatusSlaveVer15(0L);
    static final Reader READER = new Reader();
    static final OFAsyncConfigPropPortStatusSlaveVer15Funnel FUNNEL = new OFAsyncConfigPropPortStatusSlaveVer15Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncConfigPropPortStatusSlaveVer15(long mask) {
        this.mask = mask;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public long getMask() {
        return this.mask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFAsyncConfigPropPortStatusSlave.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncConfigPropPortStatusSlaveVer15(");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncConfigPropPortStatusSlaveVer15 other = (OFAsyncConfigPropPortStatusSlaveVer15)obj;
        return this.mask == other.mask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.mask ^ this.mask >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncConfigPropPortStatusSlaveVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAsyncConfigPropPortStatusSlaveVer15 message) {
            bb.writeShort(2);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.mask));
        }
    }

    static class OFAsyncConfigPropPortStatusSlaveVer15Funnel
    implements Funnel<OFAsyncConfigPropPortStatusSlaveVer15> {
        private static final long serialVersionUID = 1L;

        OFAsyncConfigPropPortStatusSlaveVer15Funnel() {
        }

        public void funnel(OFAsyncConfigPropPortStatusSlaveVer15 message, PrimitiveSink sink) {
            sink.putShort((short)2);
            sink.putShort((short)8);
            sink.putLong(message.mask);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncConfigPropPortStatusSlave> {
        Reader() {
        }

        @Override
        public OFAsyncConfigPropPortStatusSlave readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 2) {
                throw new OFParseError("Wrong type: Expected=0x2(0x2), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long mask = U32.f(bb.readInt());
            OFAsyncConfigPropPortStatusSlaveVer15 asyncConfigPropPortStatusSlaveVer15 = new OFAsyncConfigPropPortStatusSlaveVer15(mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncConfigPropPortStatusSlaveVer15);
            }
            return asyncConfigPropPortStatusSlaveVer15;
        }
    }

    static class Builder
    implements OFAsyncConfigPropPortStatusSlave.Builder {
        private boolean maskSet;
        private long mask;

        Builder() {
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropPortStatusSlave.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFAsyncConfigPropPortStatusSlave build() {
            long mask = this.maskSet ? this.mask : 0L;
            return new OFAsyncConfigPropPortStatusSlaveVer15(mask);
        }
    }

    static class BuilderWithParent
    implements OFAsyncConfigPropPortStatusSlave.Builder {
        final OFAsyncConfigPropPortStatusSlaveVer15 parentMessage;
        private boolean maskSet;
        private long mask;

        BuilderWithParent(OFAsyncConfigPropPortStatusSlaveVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropPortStatusSlave.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFAsyncConfigPropPortStatusSlave build() {
            long mask = this.maskSet ? this.mask : this.parentMessage.mask;
            return new OFAsyncConfigPropPortStatusSlaveVer15(mask);
        }
    }
}

