/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncConfigPropFlowStatsMaster;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncConfigPropFlowStatsMasterVer15
implements OFAsyncConfigPropFlowStatsMaster {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncConfigPropFlowStatsMasterVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_MASK = 0L;
    private final long mask;
    static final OFAsyncConfigPropFlowStatsMasterVer15 DEFAULT = new OFAsyncConfigPropFlowStatsMasterVer15(0L);
    static final Reader READER = new Reader();
    static final OFAsyncConfigPropFlowStatsMasterVer15Funnel FUNNEL = new OFAsyncConfigPropFlowStatsMasterVer15Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncConfigPropFlowStatsMasterVer15(long mask) {
        this.mask = mask;
    }

    @Override
    public int getType() {
        return 13;
    }

    @Override
    public long getMask() {
        return this.mask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFAsyncConfigPropFlowStatsMaster.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncConfigPropFlowStatsMasterVer15(");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncConfigPropFlowStatsMasterVer15 other = (OFAsyncConfigPropFlowStatsMasterVer15)obj;
        return this.mask == other.mask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.mask ^ this.mask >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncConfigPropFlowStatsMasterVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAsyncConfigPropFlowStatsMasterVer15 message) {
            bb.writeShort(13);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.mask));
        }
    }

    static class OFAsyncConfigPropFlowStatsMasterVer15Funnel
    implements Funnel<OFAsyncConfigPropFlowStatsMasterVer15> {
        private static final long serialVersionUID = 1L;

        OFAsyncConfigPropFlowStatsMasterVer15Funnel() {
        }

        public void funnel(OFAsyncConfigPropFlowStatsMasterVer15 message, PrimitiveSink sink) {
            sink.putShort((short)13);
            sink.putShort((short)8);
            sink.putLong(message.mask);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncConfigPropFlowStatsMaster> {
        Reader() {
        }

        @Override
        public OFAsyncConfigPropFlowStatsMaster readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 13) {
                throw new OFParseError("Wrong type: Expected=0xd(0xd), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long mask = U32.f(bb.readInt());
            OFAsyncConfigPropFlowStatsMasterVer15 asyncConfigPropFlowStatsMasterVer15 = new OFAsyncConfigPropFlowStatsMasterVer15(mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncConfigPropFlowStatsMasterVer15);
            }
            return asyncConfigPropFlowStatsMasterVer15;
        }
    }

    static class Builder
    implements OFAsyncConfigPropFlowStatsMaster.Builder {
        private boolean maskSet;
        private long mask;

        Builder() {
        }

        @Override
        public int getType() {
            return 13;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropFlowStatsMaster.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFAsyncConfigPropFlowStatsMaster build() {
            long mask = this.maskSet ? this.mask : 0L;
            return new OFAsyncConfigPropFlowStatsMasterVer15(mask);
        }
    }

    static class BuilderWithParent
    implements OFAsyncConfigPropFlowStatsMaster.Builder {
        final OFAsyncConfigPropFlowStatsMasterVer15 parentMessage;
        private boolean maskSet;
        private long mask;

        BuilderWithParent(OFAsyncConfigPropFlowStatsMasterVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 13;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropFlowStatsMaster.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFAsyncConfigPropFlowStatsMaster build() {
            long mask = this.maskSet ? this.mask : this.parentMessage.mask;
            return new OFAsyncConfigPropFlowStatsMasterVer15(mask);
        }
    }
}

