/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionMeter;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionMeterVer15
implements OFActionMeter {
    private static final Logger logger = LoggerFactory.getLogger(OFActionMeterVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_METER_ID = 0L;
    private final long meterId;
    static final OFActionMeterVer15 DEFAULT = new OFActionMeterVer15(0L);
    static final Reader READER = new Reader();
    static final OFActionMeterVer15Funnel FUNNEL = new OFActionMeterVer15Funnel();
    static final Writer WRITER = new Writer();

    OFActionMeterVer15(long meterId) {
        this.meterId = meterId;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.METER;
    }

    @Override
    public long getMeterId() {
        return this.meterId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFActionMeter.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionMeterVer15(");
        b.append("meterId=").append(this.meterId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionMeterVer15 other = (OFActionMeterVer15)obj;
        return this.meterId == other.meterId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.meterId ^ this.meterId >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionMeterVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionMeterVer15 message) {
            bb.writeShort(29);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.meterId));
        }
    }

    static class OFActionMeterVer15Funnel
    implements Funnel<OFActionMeterVer15> {
        private static final long serialVersionUID = 1L;

        OFActionMeterVer15Funnel() {
        }

        public void funnel(OFActionMeterVer15 message, PrimitiveSink sink) {
            sink.putShort((short)29);
            sink.putShort((short)8);
            sink.putLong(message.meterId);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionMeter> {
        Reader() {
        }

        @Override
        public OFActionMeter readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 29) {
                throw new OFParseError("Wrong type: Expected=OFActionType.METER(29), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long meterId = U32.f(bb.readInt());
            OFActionMeterVer15 actionMeterVer15 = new OFActionMeterVer15(meterId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionMeterVer15);
            }
            return actionMeterVer15;
        }
    }

    static class Builder
    implements OFActionMeter.Builder {
        private boolean meterIdSet;
        private long meterId;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.METER;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFActionMeter.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFActionMeter build() {
            long meterId = this.meterIdSet ? this.meterId : 0L;
            return new OFActionMeterVer15(meterId);
        }
    }

    static class BuilderWithParent
    implements OFActionMeter.Builder {
        final OFActionMeterVer15 parentMessage;
        private boolean meterIdSet;
        private long meterId;

        BuilderWithParent(OFActionMeterVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.METER;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFActionMeter.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFActionMeter build() {
            long meterId = this.meterIdSet ? this.meterId : this.parentMessage.meterId;
            return new OFActionMeterVer15(meterId);
        }
    }
}

