/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdSetQueue;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdSetQueueVer15
implements OFActionIdSetQueue {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdSetQueueVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 4;
    static final OFActionIdSetQueueVer15 DEFAULT = new OFActionIdSetQueueVer15();
    static final OFActionIdSetQueueVer15 INSTANCE = new OFActionIdSetQueueVer15();
    static final Reader READER = new Reader();
    static final OFActionIdSetQueueVer15Funnel FUNNEL = new OFActionIdSetQueueVer15Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdSetQueueVer15() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_QUEUE;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFActionIdSetQueue.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdSetQueueVer15 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdSetQueueVer15(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdSetQueueVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionIdSetQueueVer15 message) {
            bb.writeShort(21);
            bb.writeShort(4);
        }
    }

    static class OFActionIdSetQueueVer15Funnel
    implements Funnel<OFActionIdSetQueueVer15> {
        private static final long serialVersionUID = 1L;

        OFActionIdSetQueueVer15Funnel() {
        }

        public void funnel(OFActionIdSetQueueVer15 message, PrimitiveSink sink) {
            sink.putShort((short)21);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdSetQueue> {
        Reader() {
        }

        @Override
        public OFActionIdSetQueue readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 21) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_QUEUE(21), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

