/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropWildcards;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropWildcardsVer14
implements OFTableFeaturePropWildcards {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropWildcardsVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 4;
    private static final List<U32> DEFAULT_OXM_IDS = ImmutableList.of();
    private final List<U32> oxmIds;
    static final OFTableFeaturePropWildcardsVer14 DEFAULT = new OFTableFeaturePropWildcardsVer14(DEFAULT_OXM_IDS);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropWildcardsVer14Funnel FUNNEL = new OFTableFeaturePropWildcardsVer14Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropWildcardsVer14(List<U32> oxmIds) {
        if (oxmIds == null) {
            throw new NullPointerException("OFTableFeaturePropWildcardsVer14: property oxmIds cannot be null");
        }
        this.oxmIds = oxmIds;
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    public List<U32> getOxmIds() {
        return this.oxmIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFTableFeaturePropWildcards.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropWildcardsVer14(");
        b.append("oxmIds=").append(this.oxmIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropWildcardsVer14 other = (OFTableFeaturePropWildcardsVer14)obj;
        return !(this.oxmIds == null ? other.oxmIds != null : !this.oxmIds.equals(other.oxmIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.oxmIds == null ? 0 : this.oxmIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropWildcardsVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableFeaturePropWildcardsVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(10);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.oxmIds);
            int length = bb.writerIndex() - startIndex;
            int alignedLength = (length + 7) / 8 * 8;
            bb.setShort(lengthIndex, length);
            bb.writeZero(alignedLength - length);
        }
    }

    static class OFTableFeaturePropWildcardsVer14Funnel
    implements Funnel<OFTableFeaturePropWildcardsVer14> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropWildcardsVer14Funnel() {
        }

        public void funnel(OFTableFeaturePropWildcardsVer14 message, PrimitiveSink sink) {
            sink.putShort((short)10);
            FunnelUtils.putList(message.oxmIds, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropWildcards> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropWildcards readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 10) {
                throw new OFParseError("Wrong type: Expected=0xa(0xa), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<U32> oxmIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U32.READER);
            bb.skipBytes((length + 7) / 8 * 8 - length);
            OFTableFeaturePropWildcardsVer14 tableFeaturePropWildcardsVer14 = new OFTableFeaturePropWildcardsVer14(oxmIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropWildcardsVer14);
            }
            return tableFeaturePropWildcardsVer14;
        }
    }

    static class Builder
    implements OFTableFeaturePropWildcards.Builder {
        private boolean oxmIdsSet;
        private List<U32> oxmIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 10;
        }

        @Override
        public List<U32> getOxmIds() {
            return this.oxmIds;
        }

        @Override
        public OFTableFeaturePropWildcards.Builder setOxmIds(List<U32> oxmIds) {
            this.oxmIds = oxmIds;
            this.oxmIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropWildcards build() {
            List<U32> oxmIds;
            List<U32> list = oxmIds = this.oxmIdsSet ? this.oxmIds : DEFAULT_OXM_IDS;
            if (oxmIds == null) {
                throw new NullPointerException("Property oxmIds must not be null");
            }
            return new OFTableFeaturePropWildcardsVer14(oxmIds);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropWildcards.Builder {
        final OFTableFeaturePropWildcardsVer14 parentMessage;
        private boolean oxmIdsSet;
        private List<U32> oxmIds;

        BuilderWithParent(OFTableFeaturePropWildcardsVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 10;
        }

        @Override
        public List<U32> getOxmIds() {
            return this.oxmIds;
        }

        @Override
        public OFTableFeaturePropWildcards.Builder setOxmIds(List<U32> oxmIds) {
            this.oxmIds = oxmIds;
            this.oxmIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropWildcards build() {
            List oxmIds;
            List list = oxmIds = this.oxmIdsSet ? this.oxmIds : this.parentMessage.oxmIds;
            if (oxmIds == null) {
                throw new NullPointerException("Property oxmIds must not be null");
            }
            return new OFTableFeaturePropWildcardsVer14(oxmIds);
        }
    }
}

