/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropApplyActions;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionId;
import org.projectfloodlight.openflow.protocol.ver14.OFActionIdVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropApplyActionsVer14
implements OFTableFeaturePropApplyActions {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropApplyActionsVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 4;
    private static final List<OFActionId> DEFAULT_ACTION_IDS = ImmutableList.of();
    private final List<OFActionId> actionIds;
    static final OFTableFeaturePropApplyActionsVer14 DEFAULT = new OFTableFeaturePropApplyActionsVer14(DEFAULT_ACTION_IDS);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropApplyActionsVer14Funnel FUNNEL = new OFTableFeaturePropApplyActionsVer14Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropApplyActionsVer14(List<OFActionId> actionIds) {
        if (actionIds == null) {
            throw new NullPointerException("OFTableFeaturePropApplyActionsVer14: property actionIds cannot be null");
        }
        this.actionIds = actionIds;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public List<OFActionId> getActionIds() {
        return this.actionIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFTableFeaturePropApplyActions.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropApplyActionsVer14(");
        b.append("actionIds=").append(this.actionIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropApplyActionsVer14 other = (OFTableFeaturePropApplyActionsVer14)obj;
        return !(this.actionIds == null ? other.actionIds != null : !this.actionIds.equals(other.actionIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actionIds == null ? 0 : this.actionIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropApplyActionsVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableFeaturePropApplyActionsVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(6);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.actionIds);
            int length = bb.writerIndex() - startIndex;
            int alignedLength = (length + 7) / 8 * 8;
            bb.setShort(lengthIndex, length);
            bb.writeZero(alignedLength - length);
        }
    }

    static class OFTableFeaturePropApplyActionsVer14Funnel
    implements Funnel<OFTableFeaturePropApplyActionsVer14> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropApplyActionsVer14Funnel() {
        }

        public void funnel(OFTableFeaturePropApplyActionsVer14 message, PrimitiveSink sink) {
            sink.putShort((short)6);
            FunnelUtils.putList(message.actionIds, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropApplyActions> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropApplyActions readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 6) {
                throw new OFParseError("Wrong type: Expected=0x6(0x6), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<OFActionId> actionIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFActionIdVer14.READER);
            bb.skipBytes((length + 7) / 8 * 8 - length);
            OFTableFeaturePropApplyActionsVer14 tableFeaturePropApplyActionsVer14 = new OFTableFeaturePropApplyActionsVer14(actionIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropApplyActionsVer14);
            }
            return tableFeaturePropApplyActionsVer14;
        }
    }

    static class Builder
    implements OFTableFeaturePropApplyActions.Builder {
        private boolean actionIdsSet;
        private List<OFActionId> actionIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 6;
        }

        @Override
        public List<OFActionId> getActionIds() {
            return this.actionIds;
        }

        @Override
        public OFTableFeaturePropApplyActions.Builder setActionIds(List<OFActionId> actionIds) {
            this.actionIds = actionIds;
            this.actionIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropApplyActions build() {
            List<OFActionId> actionIds;
            List<OFActionId> list = actionIds = this.actionIdsSet ? this.actionIds : DEFAULT_ACTION_IDS;
            if (actionIds == null) {
                throw new NullPointerException("Property actionIds must not be null");
            }
            return new OFTableFeaturePropApplyActionsVer14(actionIds);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropApplyActions.Builder {
        final OFTableFeaturePropApplyActionsVer14 parentMessage;
        private boolean actionIdsSet;
        private List<OFActionId> actionIds;

        BuilderWithParent(OFTableFeaturePropApplyActionsVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 6;
        }

        @Override
        public List<OFActionId> getActionIds() {
            return this.actionIds;
        }

        @Override
        public OFTableFeaturePropApplyActions.Builder setActionIds(List<OFActionId> actionIds) {
            this.actionIds = actionIds;
            this.actionIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropApplyActions build() {
            List actionIds;
            List list = actionIds = this.actionIdsSet ? this.actionIds : this.parentMessage.actionIds;
            if (actionIds == null) {
                throw new NullPointerException("Property actionIds must not be null");
            }
            return new OFTableFeaturePropApplyActionsVer14(actionIds);
        }
    }
}

