/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFRequestforward;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFRequestforwardVer14
implements OFRequestforward {
    private static final Logger logger = LoggerFactory.getLogger(OFRequestforwardVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 12;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_ROLE = 0L;
    private static final byte[] DEFAULT_DATA = new byte[0];
    private final long xid;
    private final long role;
    private final byte[] data;
    static final OFRequestforwardVer14 DEFAULT = new OFRequestforwardVer14(0L, 0L, DEFAULT_DATA);
    static final Reader READER = new Reader();
    static final OFRequestforwardVer14Funnel FUNNEL = new OFRequestforwardVer14Funnel();
    static final Writer WRITER = new Writer();

    OFRequestforwardVer14(long xid, long role, byte[] data) {
        if (data == null) {
            throw new NullPointerException("OFRequestforwardVer14: property data cannot be null");
        }
        this.xid = xid;
        this.role = role;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.REQUESTFORWARD;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFMessage getRequest() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property request not supported in version 1.4");
    }

    @Override
    public long getRole() {
        return this.role;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public OFRequestforward.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFRequestforwardVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("role=").append(this.role);
        b.append(", ");
        b.append("data=").append(Arrays.toString(this.data));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFRequestforwardVer14 other = (OFRequestforwardVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.role != other.role) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFRequestforwardVer14 other = (OFRequestforwardVer14)obj;
        if (this.role != other.role) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.role ^ this.role >>> 32);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.role ^ this.role >>> 32);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFRequestforwardVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFRequestforwardVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(5);
            bb.writeByte(32);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(U32.t(message.role));
            bb.writeBytes(message.data);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFRequestforwardVer14Funnel
    implements Funnel<OFRequestforwardVer14> {
        private static final long serialVersionUID = 1L;

        OFRequestforwardVer14Funnel() {
        }

        public void funnel(OFRequestforwardVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)32);
            sink.putLong(message.xid);
            sink.putLong(message.role);
            sink.putBytes(message.data);
        }
    }

    static class Reader
    implements OFMessageReader<OFRequestforward> {
        Reader() {
        }

        @Override
        public OFRequestforward readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 32) {
                throw new OFParseError("Wrong type: Expected=OFType.REQUESTFORWARD(32), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            long role = U32.f(bb.readInt());
            byte[] data = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFRequestforwardVer14 requestforwardVer14 = new OFRequestforwardVer14(xid, role, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)requestforwardVer14);
            }
            return requestforwardVer14;
        }
    }

    static class Builder
    implements OFRequestforward.Builder {
        private boolean xidSet;
        private long xid;
        private boolean roleSet;
        private long role;
        private boolean dataSet;
        private byte[] data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.REQUESTFORWARD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFRequestforward.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFMessage getRequest() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property request not supported in version 1.4");
        }

        @Override
        public OFRequestforward.Builder setRequest(OFMessage request) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property request not supported in version 1.4");
        }

        @Override
        public long getRole() {
            return this.role;
        }

        @Override
        public OFRequestforward.Builder setRole(long role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFRequestforward.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFRequestforward build() {
            byte[] data;
            long xid = this.xidSet ? this.xid : 0L;
            long role = this.roleSet ? this.role : 0L;
            byte[] byArray = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFRequestforwardVer14(xid, role, data);
        }
    }

    static class BuilderWithParent
    implements OFRequestforward.Builder {
        final OFRequestforwardVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean roleSet;
        private long role;
        private boolean dataSet;
        private byte[] data;

        BuilderWithParent(OFRequestforwardVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.REQUESTFORWARD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFRequestforward.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFMessage getRequest() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property request not supported in version 1.4");
        }

        @Override
        public OFRequestforward.Builder setRequest(OFMessage request) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property request not supported in version 1.4");
        }

        @Override
        public long getRole() {
            return this.role;
        }

        @Override
        public OFRequestforward.Builder setRole(long role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFRequestforward.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFRequestforward build() {
            byte[] data;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long role = this.roleSet ? this.role : this.parentMessage.role;
            byte[] byArray = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFRequestforwardVer14(xid, role, data);
        }
    }
}

