/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescPropEthernet;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescPropEthernetVer14
implements OFPortDescPropEthernet {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropEthernetVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 32;
    private static final long DEFAULT_CURR = 0L;
    private static final long DEFAULT_ADVERTISED = 0L;
    private static final long DEFAULT_SUPPORTED = 0L;
    private static final long DEFAULT_PEER = 0L;
    private static final long DEFAULT_CURR_SPEED = 0L;
    private static final long DEFAULT_MAX_SPEED = 0L;
    private final long curr;
    private final long advertised;
    private final long supported;
    private final long peer;
    private final long currSpeed;
    private final long maxSpeed;
    static final OFPortDescPropEthernetVer14 DEFAULT = new OFPortDescPropEthernetVer14(0L, 0L, 0L, 0L, 0L, 0L);
    static final Reader READER = new Reader();
    static final OFPortDescPropEthernetVer14Funnel FUNNEL = new OFPortDescPropEthernetVer14Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescPropEthernetVer14(long curr, long advertised, long supported, long peer, long currSpeed, long maxSpeed) {
        this.curr = curr;
        this.advertised = advertised;
        this.supported = supported;
        this.peer = peer;
        this.currSpeed = currSpeed;
        this.maxSpeed = maxSpeed;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public long getCurr() {
        return this.curr;
    }

    @Override
    public long getAdvertised() {
        return this.advertised;
    }

    @Override
    public long getSupported() {
        return this.supported;
    }

    @Override
    public long getPeer() {
        return this.peer;
    }

    @Override
    public long getCurrSpeed() {
        return this.currSpeed;
    }

    @Override
    public long getMaxSpeed() {
        return this.maxSpeed;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFPortDescPropEthernet.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropEthernetVer14(");
        b.append("curr=").append(this.curr);
        b.append(", ");
        b.append("advertised=").append(this.advertised);
        b.append(", ");
        b.append("supported=").append(this.supported);
        b.append(", ");
        b.append("peer=").append(this.peer);
        b.append(", ");
        b.append("currSpeed=").append(this.currSpeed);
        b.append(", ");
        b.append("maxSpeed=").append(this.maxSpeed);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescPropEthernetVer14 other = (OFPortDescPropEthernetVer14)obj;
        if (this.curr != other.curr) {
            return false;
        }
        if (this.advertised != other.advertised) {
            return false;
        }
        if (this.supported != other.supported) {
            return false;
        }
        if (this.peer != other.peer) {
            return false;
        }
        if (this.currSpeed != other.currSpeed) {
            return false;
        }
        return this.maxSpeed == other.maxSpeed;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.curr ^ this.curr >>> 32);
        result = 31 * (int)(this.advertised ^ this.advertised >>> 32);
        result = 31 * (int)(this.supported ^ this.supported >>> 32);
        result = 31 * (int)(this.peer ^ this.peer >>> 32);
        result = 31 * (int)(this.currSpeed ^ this.currSpeed >>> 32);
        result = 31 * (int)(this.maxSpeed ^ this.maxSpeed >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescPropEthernetVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortDescPropEthernetVer14 message) {
            bb.writeShort(0);
            bb.writeShort(32);
            bb.writeZero(4);
            bb.writeInt(U32.t(message.curr));
            bb.writeInt(U32.t(message.advertised));
            bb.writeInt(U32.t(message.supported));
            bb.writeInt(U32.t(message.peer));
            bb.writeInt(U32.t(message.currSpeed));
            bb.writeInt(U32.t(message.maxSpeed));
        }
    }

    static class OFPortDescPropEthernetVer14Funnel
    implements Funnel<OFPortDescPropEthernetVer14> {
        private static final long serialVersionUID = 1L;

        OFPortDescPropEthernetVer14Funnel() {
        }

        public void funnel(OFPortDescPropEthernetVer14 message, PrimitiveSink sink) {
            sink.putShort((short)0);
            sink.putShort((short)32);
            sink.putLong(message.curr);
            sink.putLong(message.advertised);
            sink.putLong(message.supported);
            sink.putLong(message.peer);
            sink.putLong(message.currSpeed);
            sink.putLong(message.maxSpeed);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropEthernet> {
        Reader() {
        }

        @Override
        public OFPortDescPropEthernet readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=0x0(0x0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 32) {
                throw new OFParseError("Wrong length: Expected=32(32), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            long curr = U32.f(bb.readInt());
            long advertised = U32.f(bb.readInt());
            long supported = U32.f(bb.readInt());
            long peer = U32.f(bb.readInt());
            long currSpeed = U32.f(bb.readInt());
            long maxSpeed = U32.f(bb.readInt());
            OFPortDescPropEthernetVer14 portDescPropEthernetVer14 = new OFPortDescPropEthernetVer14(curr, advertised, supported, peer, currSpeed, maxSpeed);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescPropEthernetVer14);
            }
            return portDescPropEthernetVer14;
        }
    }

    static class Builder
    implements OFPortDescPropEthernet.Builder {
        private boolean currSet;
        private long curr;
        private boolean advertisedSet;
        private long advertised;
        private boolean supportedSet;
        private long supported;
        private boolean peerSet;
        private long peer;
        private boolean currSpeedSet;
        private long currSpeed;
        private boolean maxSpeedSet;
        private long maxSpeed;

        Builder() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public long getCurr() {
            return this.curr;
        }

        @Override
        public OFPortDescPropEthernet.Builder setCurr(long curr) {
            this.curr = curr;
            this.currSet = true;
            return this;
        }

        @Override
        public long getAdvertised() {
            return this.advertised;
        }

        @Override
        public OFPortDescPropEthernet.Builder setAdvertised(long advertised) {
            this.advertised = advertised;
            this.advertisedSet = true;
            return this;
        }

        @Override
        public long getSupported() {
            return this.supported;
        }

        @Override
        public OFPortDescPropEthernet.Builder setSupported(long supported) {
            this.supported = supported;
            this.supportedSet = true;
            return this;
        }

        @Override
        public long getPeer() {
            return this.peer;
        }

        @Override
        public OFPortDescPropEthernet.Builder setPeer(long peer) {
            this.peer = peer;
            this.peerSet = true;
            return this;
        }

        @Override
        public long getCurrSpeed() {
            return this.currSpeed;
        }

        @Override
        public OFPortDescPropEthernet.Builder setCurrSpeed(long currSpeed) {
            this.currSpeed = currSpeed;
            this.currSpeedSet = true;
            return this;
        }

        @Override
        public long getMaxSpeed() {
            return this.maxSpeed;
        }

        @Override
        public OFPortDescPropEthernet.Builder setMaxSpeed(long maxSpeed) {
            this.maxSpeed = maxSpeed;
            this.maxSpeedSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortDescPropEthernet build() {
            long curr = this.currSet ? this.curr : 0L;
            long advertised = this.advertisedSet ? this.advertised : 0L;
            long supported = this.supportedSet ? this.supported : 0L;
            long peer = this.peerSet ? this.peer : 0L;
            long currSpeed = this.currSpeedSet ? this.currSpeed : 0L;
            long maxSpeed = this.maxSpeedSet ? this.maxSpeed : 0L;
            return new OFPortDescPropEthernetVer14(curr, advertised, supported, peer, currSpeed, maxSpeed);
        }
    }

    static class BuilderWithParent
    implements OFPortDescPropEthernet.Builder {
        final OFPortDescPropEthernetVer14 parentMessage;
        private boolean currSet;
        private long curr;
        private boolean advertisedSet;
        private long advertised;
        private boolean supportedSet;
        private long supported;
        private boolean peerSet;
        private long peer;
        private boolean currSpeedSet;
        private long currSpeed;
        private boolean maxSpeedSet;
        private long maxSpeed;

        BuilderWithParent(OFPortDescPropEthernetVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public long getCurr() {
            return this.curr;
        }

        @Override
        public OFPortDescPropEthernet.Builder setCurr(long curr) {
            this.curr = curr;
            this.currSet = true;
            return this;
        }

        @Override
        public long getAdvertised() {
            return this.advertised;
        }

        @Override
        public OFPortDescPropEthernet.Builder setAdvertised(long advertised) {
            this.advertised = advertised;
            this.advertisedSet = true;
            return this;
        }

        @Override
        public long getSupported() {
            return this.supported;
        }

        @Override
        public OFPortDescPropEthernet.Builder setSupported(long supported) {
            this.supported = supported;
            this.supportedSet = true;
            return this;
        }

        @Override
        public long getPeer() {
            return this.peer;
        }

        @Override
        public OFPortDescPropEthernet.Builder setPeer(long peer) {
            this.peer = peer;
            this.peerSet = true;
            return this;
        }

        @Override
        public long getCurrSpeed() {
            return this.currSpeed;
        }

        @Override
        public OFPortDescPropEthernet.Builder setCurrSpeed(long currSpeed) {
            this.currSpeed = currSpeed;
            this.currSpeedSet = true;
            return this;
        }

        @Override
        public long getMaxSpeed() {
            return this.maxSpeed;
        }

        @Override
        public OFPortDescPropEthernet.Builder setMaxSpeed(long maxSpeed) {
            this.maxSpeed = maxSpeed;
            this.maxSpeedSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortDescPropEthernet build() {
            long curr = this.currSet ? this.curr : this.parentMessage.curr;
            long advertised = this.advertisedSet ? this.advertised : this.parentMessage.advertised;
            long supported = this.supportedSet ? this.supported : this.parentMessage.supported;
            long peer = this.peerSet ? this.peer : this.parentMessage.peer;
            long currSpeed = this.currSpeedSet ? this.currSpeed : this.parentMessage.currSpeed;
            long maxSpeed = this.maxSpeedSet ? this.maxSpeed : this.parentMessage.maxSpeed;
            return new OFPortDescPropEthernetVer14(curr, advertised, supported, peer, currSpeed, maxSpeed);
        }
    }
}

