/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescPropBsnEthtool;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescPropBsnEthtoolVer14
implements OFPortDescPropBsnEthtool {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropBsnEthtoolVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 12;
    private static final byte[] DEFAULT_DATA = new byte[0];
    private final byte[] data;
    static final OFPortDescPropBsnEthtoolVer14 DEFAULT = new OFPortDescPropBsnEthtoolVer14(DEFAULT_DATA);
    static final Reader READER = new Reader();
    static final OFPortDescPropBsnEthtoolVer14Funnel FUNNEL = new OFPortDescPropBsnEthtoolVer14Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescPropBsnEthtoolVer14(byte[] data) {
        if (data == null) {
            throw new NullPointerException("OFPortDescPropBsnEthtoolVer14: property data cannot be null");
        }
        this.data = data;
    }

    @Override
    public int getType() {
        return 65535;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getExpType() {
        return 6L;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFPortDescPropBsnEthtool.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropBsnEthtoolVer14(");
        b.append("data=").append(Arrays.toString(this.data));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescPropBsnEthtoolVer14 other = (OFPortDescPropBsnEthtoolVer14)obj;
        return Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescPropBsnEthtoolVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortDescPropBsnEthtoolVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(-1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(6035143);
            bb.writeInt(6);
            bb.writeBytes(message.data);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPortDescPropBsnEthtoolVer14Funnel
    implements Funnel<OFPortDescPropBsnEthtoolVer14> {
        private static final long serialVersionUID = 1L;

        OFPortDescPropBsnEthtoolVer14Funnel() {
        }

        public void funnel(OFPortDescPropBsnEthtoolVer14 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putInt(6035143);
            sink.putInt(6);
            sink.putBytes(message.data);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropBsnEthtool> {
        Reader() {
        }

        @Override
        public OFPortDescPropBsnEthtool readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int expType = bb.readInt();
            if (expType != 6) {
                throw new OFParseError("Wrong expType: Expected=0x6L(0x6L), got=" + expType);
            }
            byte[] data = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFPortDescPropBsnEthtoolVer14 portDescPropBsnEthtoolVer14 = new OFPortDescPropBsnEthtoolVer14(data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescPropBsnEthtoolVer14);
            }
            return portDescPropBsnEthtoolVer14;
        }
    }

    static class Builder
    implements OFPortDescPropBsnEthtool.Builder {
        private boolean dataSet;
        private byte[] data;

        Builder() {
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 6L;
        }

        @Override
        public OFPortDescPropBsnEthtool.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFPortDescPropBsnEthtool.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortDescPropBsnEthtool build() {
            byte[] data;
            byte[] byArray = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFPortDescPropBsnEthtoolVer14(data);
        }
    }

    static class BuilderWithParent
    implements OFPortDescPropBsnEthtool.Builder {
        final OFPortDescPropBsnEthtoolVer14 parentMessage;
        private boolean dataSet;
        private byte[] data;

        BuilderWithParent(OFPortDescPropBsnEthtoolVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 6L;
        }

        @Override
        public OFPortDescPropBsnEthtool.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFPortDescPropBsnEthtool.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortDescPropBsnEthtool build() {
            byte[] data;
            byte[] byArray = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFPortDescPropBsnEthtoolVer14(data);
        }
    }
}

