/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConnTrackingLabel;
import org.projectfloodlight.openflow.types.U128;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmConnTrackingLabelVer14
implements OFOxmConnTrackingLabel {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmConnTrackingLabelVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 20;
    private static final U128 DEFAULT_VALUE = U128.ZERO;
    private final U128 value;
    static final OFOxmConnTrackingLabelVer14 DEFAULT = new OFOxmConnTrackingLabelVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmConnTrackingLabelVer14Funnel FUNNEL = new OFOxmConnTrackingLabelVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmConnTrackingLabelVer14(U128 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmConnTrackingLabelVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 120848L;
    }

    @Override
    public U128 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U128> getMatchField() {
        return MatchField.CONN_TRACKING_LABEL;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U128> getCanonical() {
        return this;
    }

    @Override
    public U128 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmConnTrackingLabel.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmConnTrackingLabelVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmConnTrackingLabelVer14 other = (OFOxmConnTrackingLabelVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmConnTrackingLabelVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmConnTrackingLabelVer14 message) {
            bb.writeInt(120848);
            message.value.write16Bytes(bb);
        }
    }

    static class OFOxmConnTrackingLabelVer14Funnel
    implements Funnel<OFOxmConnTrackingLabelVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmConnTrackingLabelVer14Funnel() {
        }

        public void funnel(OFOxmConnTrackingLabelVer14 message, PrimitiveSink sink) {
            sink.putInt(120848);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmConnTrackingLabel> {
        Reader() {
        }

        @Override
        public OFOxmConnTrackingLabel readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 120848) {
                throw new OFParseError("Wrong typeLen: Expected=0x1d810L(0x1d810L), got=" + typeLen);
            }
            U128 value = U128.read16Bytes(bb);
            OFOxmConnTrackingLabelVer14 oxmConnTrackingLabelVer14 = new OFOxmConnTrackingLabelVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmConnTrackingLabelVer14);
            }
            return oxmConnTrackingLabelVer14;
        }
    }

    static class Builder
    implements OFOxmConnTrackingLabel.Builder {
        private boolean valueSet;
        private U128 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 120848L;
        }

        @Override
        public U128 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingLabel.Builder setValue(U128 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U128> getMatchField() {
            return MatchField.CONN_TRACKING_LABEL;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U128> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public U128 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmConnTrackingLabel build() {
            U128 value;
            U128 u128 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmConnTrackingLabelVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmConnTrackingLabel.Builder {
        final OFOxmConnTrackingLabelVer14 parentMessage;
        private boolean valueSet;
        private U128 value;

        BuilderWithParent(OFOxmConnTrackingLabelVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 120848L;
        }

        @Override
        public U128 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingLabel.Builder setValue(U128 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U128> getMatchField() {
            return MatchField.CONN_TRACKING_LABEL;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U128> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public U128 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmConnTrackingLabel build() {
            U128 value;
            U128 u128 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmConnTrackingLabelVer14(value);
        }
    }
}

