/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnVfi;
import org.projectfloodlight.openflow.types.VFI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnVfiVer14
implements OFOxmBsnVfi {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnVfiVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private static final VFI DEFAULT_VALUE = VFI.ZERO;
    private final VFI value;
    static final OFOxmBsnVfiVer14 DEFAULT = new OFOxmBsnVfiVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnVfiVer14Funnel FUNNEL = new OFOxmBsnVfiVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnVfiVer14(VFI value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnVfiVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 209410L;
    }

    @Override
    public VFI getValue() {
        return this.value;
    }

    @Override
    public MatchField<VFI> getMatchField() {
        return MatchField.BSN_VFI;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<VFI> getCanonical() {
        return this;
    }

    @Override
    public VFI getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmBsnVfi.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnVfiVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnVfiVer14 other = (OFOxmBsnVfiVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnVfiVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnVfiVer14 message) {
            bb.writeInt(209410);
            message.value.write2Bytes(bb);
        }
    }

    static class OFOxmBsnVfiVer14Funnel
    implements Funnel<OFOxmBsnVfiVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnVfiVer14Funnel() {
        }

        public void funnel(OFOxmBsnVfiVer14 message, PrimitiveSink sink) {
            sink.putInt(209410);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnVfi> {
        Reader() {
        }

        @Override
        public OFOxmBsnVfi readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 209410) {
                throw new OFParseError("Wrong typeLen: Expected=0x33202L(0x33202L), got=" + typeLen);
            }
            VFI value = VFI.read2Bytes(bb);
            OFOxmBsnVfiVer14 oxmBsnVfiVer14 = new OFOxmBsnVfiVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnVfiVer14);
            }
            return oxmBsnVfiVer14;
        }
    }

    static class Builder
    implements OFOxmBsnVfi.Builder {
        private boolean valueSet;
        private VFI value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 209410L;
        }

        @Override
        public VFI getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVfi.Builder setValue(VFI value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<VFI> getMatchField() {
            return MatchField.BSN_VFI;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<VFI> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public VFI getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnVfi build() {
            VFI value;
            VFI vFI = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnVfiVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnVfi.Builder {
        final OFOxmBsnVfiVer14 parentMessage;
        private boolean valueSet;
        private VFI value;

        BuilderWithParent(OFOxmBsnVfiVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 209410L;
        }

        @Override
        public VFI getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVfi.Builder setValue(VFI value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<VFI> getMatchField() {
            return MatchField.BSN_VFI;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<VFI> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public VFI getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnVfi build() {
            VFI value;
            VFI vFI = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnVfiVer14(value);
        }
    }
}

