/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnIpFragmentation;
import org.projectfloodlight.openflow.types.OFBooleanValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnIpFragmentationVer14
implements OFOxmBsnIpFragmentation {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnIpFragmentationVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private static final OFBooleanValue DEFAULT_VALUE = OFBooleanValue.FALSE;
    private final OFBooleanValue value;
    static final OFOxmBsnIpFragmentationVer14 DEFAULT = new OFOxmBsnIpFragmentationVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnIpFragmentationVer14Funnel FUNNEL = new OFOxmBsnIpFragmentationVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnIpFragmentationVer14(OFBooleanValue value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnIpFragmentationVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 209921L;
    }

    @Override
    public OFBooleanValue getValue() {
        return this.value;
    }

    @Override
    public MatchField<OFBooleanValue> getMatchField() {
        return MatchField.BSN_IP_FRAGMENTATION;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<OFBooleanValue> getCanonical() {
        return this;
    }

    @Override
    public OFBooleanValue getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmBsnIpFragmentation.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnIpFragmentationVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnIpFragmentationVer14 other = (OFOxmBsnIpFragmentationVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnIpFragmentationVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnIpFragmentationVer14 message) {
            bb.writeInt(209921);
            bb.writeByte(message.value.getInt());
        }
    }

    static class OFOxmBsnIpFragmentationVer14Funnel
    implements Funnel<OFOxmBsnIpFragmentationVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnIpFragmentationVer14Funnel() {
        }

        public void funnel(OFOxmBsnIpFragmentationVer14 message, PrimitiveSink sink) {
            sink.putInt(209921);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnIpFragmentation> {
        Reader() {
        }

        @Override
        public OFOxmBsnIpFragmentation readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 209921) {
                throw new OFParseError("Wrong typeLen: Expected=0x33401L(0x33401L), got=" + typeLen);
            }
            OFBooleanValue value = OFBooleanValue.of(bb.readByte() != 0);
            OFOxmBsnIpFragmentationVer14 oxmBsnIpFragmentationVer14 = new OFOxmBsnIpFragmentationVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnIpFragmentationVer14);
            }
            return oxmBsnIpFragmentationVer14;
        }
    }

    static class Builder
    implements OFOxmBsnIpFragmentation.Builder {
        private boolean valueSet;
        private OFBooleanValue value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 209921L;
        }

        @Override
        public OFBooleanValue getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnIpFragmentation.Builder setValue(OFBooleanValue value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFBooleanValue> getMatchField() {
            return MatchField.BSN_IP_FRAGMENTATION;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFBooleanValue> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFBooleanValue getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnIpFragmentation build() {
            OFBooleanValue value;
            OFBooleanValue oFBooleanValue = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnIpFragmentationVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnIpFragmentation.Builder {
        final OFOxmBsnIpFragmentationVer14 parentMessage;
        private boolean valueSet;
        private OFBooleanValue value;

        BuilderWithParent(OFOxmBsnIpFragmentationVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 209921L;
        }

        @Override
        public OFBooleanValue getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnIpFragmentation.Builder setValue(OFBooleanValue value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFBooleanValue> getMatchField() {
            return MatchField.BSN_IP_FRAGMENTATION;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFBooleanValue> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFBooleanValue getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnIpFragmentation build() {
            OFBooleanValue value;
            OFBooleanValue oFBooleanValue = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnIpFragmentationVer14(value);
        }
    }
}

