/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;

public class OFInstructionTypeSerializerVer14 {
    public static final short GOTO_TABLE_VAL = 1;
    public static final short WRITE_METADATA_VAL = 2;
    public static final short WRITE_ACTIONS_VAL = 3;
    public static final short APPLY_ACTIONS_VAL = 4;
    public static final short CLEAR_ACTIONS_VAL = 5;
    public static final short EXPERIMENTER_VAL = -1;
    public static final short METER_VAL = 6;

    public static Set<OFInstructionType> readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFInstructionTypeSerializerVer14.ofWireValue(bb.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, Set<OFInstructionType> set) {
        bb.writeShort((int)OFInstructionTypeSerializerVer14.toWireValue(set));
    }

    public static void putTo(Set<OFInstructionType> set, PrimitiveSink sink) {
        sink.putShort(OFInstructionTypeSerializerVer14.toWireValue(set));
    }

    public static Set<OFInstructionType> ofWireValue(short val) {
        EnumSet<OFInstructionType> set = EnumSet.noneOf(OFInstructionType.class);
        if ((val & 1) != 0) {
            set.add(OFInstructionType.GOTO_TABLE);
        }
        if ((val & 2) != 0) {
            set.add(OFInstructionType.WRITE_METADATA);
        }
        if ((val & 3) != 0) {
            set.add(OFInstructionType.WRITE_ACTIONS);
        }
        if ((val & 4) != 0) {
            set.add(OFInstructionType.APPLY_ACTIONS);
        }
        if ((val & 5) != 0) {
            set.add(OFInstructionType.CLEAR_ACTIONS);
        }
        if ((val & 0xFFFFFFFF) != 0) {
            set.add(OFInstructionType.EXPERIMENTER);
        }
        if ((val & 6) != 0) {
            set.add(OFInstructionType.METER);
        }
        return Collections.unmodifiableSet(set);
    }

    public static short toWireValue(Set<OFInstructionType> set) {
        short wireValue = 0;
        block9: for (OFInstructionType e : set) {
            switch (e) {
                case GOTO_TABLE: {
                    wireValue = (short)(wireValue | 1);
                    continue block9;
                }
                case WRITE_METADATA: {
                    wireValue = (short)(wireValue | 2);
                    continue block9;
                }
                case WRITE_ACTIONS: {
                    wireValue = (short)(wireValue | 3);
                    continue block9;
                }
                case APPLY_ACTIONS: {
                    wireValue = (short)(wireValue | 4);
                    continue block9;
                }
                case CLEAR_ACTIONS: {
                    wireValue = (short)(wireValue | 5);
                    continue block9;
                }
                case EXPERIMENTER: {
                    wireValue = (short)(wireValue | 0xFFFFFFFF);
                    continue block9;
                }
                case METER: {
                    wireValue = (short)(wireValue | 6);
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFInstructionType in version 1.4: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

