/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvRxBytes;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvRxBytesVer14
implements OFBsnTlvRxBytes {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvRxBytesVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 12;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private final U64 value;
    static final OFBsnTlvRxBytesVer14 DEFAULT = new OFBsnTlvRxBytesVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvRxBytesVer14Funnel FUNNEL = new OFBsnTlvRxBytesVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvRxBytesVer14(U64 value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvRxBytesVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 71;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvRxBytes.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvRxBytesVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvRxBytesVer14 other = (OFBsnTlvRxBytesVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvRxBytesVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvRxBytesVer14 message) {
            bb.writeShort(71);
            bb.writeShort(12);
            bb.writeLong(message.value.getValue());
        }
    }

    static class OFBsnTlvRxBytesVer14Funnel
    implements Funnel<OFBsnTlvRxBytesVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvRxBytesVer14Funnel() {
        }

        public void funnel(OFBsnTlvRxBytesVer14 message, PrimitiveSink sink) {
            sink.putShort((short)71);
            sink.putShort((short)12);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvRxBytes> {
        Reader() {
        }

        @Override
        public OFBsnTlvRxBytes readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 71) {
                throw new OFParseError("Wrong type: Expected=0x47(0x47), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            U64 value = U64.ofRaw(bb.readLong());
            OFBsnTlvRxBytesVer14 bsnTlvRxBytesVer14 = new OFBsnTlvRxBytesVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvRxBytesVer14);
            }
            return bsnTlvRxBytesVer14;
        }
    }

    static class Builder
    implements OFBsnTlvRxBytes.Builder {
        private boolean valueSet;
        private U64 value;

        Builder() {
        }

        @Override
        public int getType() {
            return 71;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRxBytes.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvRxBytes build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvRxBytesVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvRxBytes.Builder {
        final OFBsnTlvRxBytesVer14 parentMessage;
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFBsnTlvRxBytesVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 71;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRxBytes.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvRxBytes build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvRxBytesVer14(value);
        }
    }
}

