/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPriority;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPriorityVer14
implements OFBsnTlvPriority {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPriorityVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvPriorityVer14 DEFAULT = new OFBsnTlvPriorityVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvPriorityVer14Funnel FUNNEL = new OFBsnTlvPriorityVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPriorityVer14(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 57;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvPriority.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPriorityVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPriorityVer14 other = (OFBsnTlvPriorityVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPriorityVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvPriorityVer14 message) {
            bb.writeShort(57);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvPriorityVer14Funnel
    implements Funnel<OFBsnTlvPriorityVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPriorityVer14Funnel() {
        }

        public void funnel(OFBsnTlvPriorityVer14 message, PrimitiveSink sink) {
            sink.putShort((short)57);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPriority> {
        Reader() {
        }

        @Override
        public OFBsnTlvPriority readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 57) {
                throw new OFParseError("Wrong type: Expected=0x39(0x39), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvPriorityVer14 bsnTlvPriorityVer14 = new OFBsnTlvPriorityVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPriorityVer14);
            }
            return bsnTlvPriorityVer14;
        }
    }

    static class Builder
    implements OFBsnTlvPriority.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 57;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPriority.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvPriority build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvPriorityVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPriority.Builder {
        final OFBsnTlvPriorityVer14 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvPriorityVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 57;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPriority.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvPriority build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvPriorityVer14(value);
        }
    }
}

