/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvMulticastInterfaceId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvMulticastInterfaceIdVer14
implements OFBsnTlvMulticastInterfaceId {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvMulticastInterfaceIdVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvMulticastInterfaceIdVer14 DEFAULT = new OFBsnTlvMulticastInterfaceIdVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvMulticastInterfaceIdVer14Funnel FUNNEL = new OFBsnTlvMulticastInterfaceIdVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvMulticastInterfaceIdVer14(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 95;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvMulticastInterfaceId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvMulticastInterfaceIdVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvMulticastInterfaceIdVer14 other = (OFBsnTlvMulticastInterfaceIdVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvMulticastInterfaceIdVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvMulticastInterfaceIdVer14 message) {
            bb.writeShort(95);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvMulticastInterfaceIdVer14Funnel
    implements Funnel<OFBsnTlvMulticastInterfaceIdVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvMulticastInterfaceIdVer14Funnel() {
        }

        public void funnel(OFBsnTlvMulticastInterfaceIdVer14 message, PrimitiveSink sink) {
            sink.putShort((short)95);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvMulticastInterfaceId> {
        Reader() {
        }

        @Override
        public OFBsnTlvMulticastInterfaceId readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 95) {
                throw new OFParseError("Wrong type: Expected=0x5f(0x5f), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvMulticastInterfaceIdVer14 bsnTlvMulticastInterfaceIdVer14 = new OFBsnTlvMulticastInterfaceIdVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvMulticastInterfaceIdVer14);
            }
            return bsnTlvMulticastInterfaceIdVer14;
        }
    }

    static class Builder
    implements OFBsnTlvMulticastInterfaceId.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 95;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMulticastInterfaceId.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvMulticastInterfaceId build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvMulticastInterfaceIdVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvMulticastInterfaceId.Builder {
        final OFBsnTlvMulticastInterfaceIdVer14 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvMulticastInterfaceIdVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 95;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMulticastInterfaceId.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvMulticastInterfaceId build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvMulticastInterfaceIdVer14(value);
        }
    }
}

