/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIcmpId;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIcmpIdVer14
implements OFBsnTlvIcmpId {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIcmpIdVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvIcmpIdVer14 DEFAULT = new OFBsnTlvIcmpIdVer14(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvIcmpIdVer14Funnel FUNNEL = new OFBsnTlvIcmpIdVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIcmpIdVer14(int value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 70;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvIcmpId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIcmpIdVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIcmpIdVer14 other = (OFBsnTlvIcmpIdVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIcmpIdVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIcmpIdVer14 message) {
            bb.writeShort(70);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvIcmpIdVer14Funnel
    implements Funnel<OFBsnTlvIcmpIdVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIcmpIdVer14Funnel() {
        }

        public void funnel(OFBsnTlvIcmpIdVer14 message, PrimitiveSink sink) {
            sink.putShort((short)70);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIcmpId> {
        Reader() {
        }

        @Override
        public OFBsnTlvIcmpId readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 70) {
                throw new OFParseError("Wrong type: Expected=0x46(0x46), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvIcmpIdVer14 bsnTlvIcmpIdVer14 = new OFBsnTlvIcmpIdVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIcmpIdVer14);
            }
            return bsnTlvIcmpIdVer14;
        }
    }

    static class Builder
    implements OFBsnTlvIcmpId.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 70;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIcmpId.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvIcmpId build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvIcmpIdVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIcmpId.Builder {
        final OFBsnTlvIcmpIdVer14 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvIcmpIdVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 70;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIcmpId.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvIcmpId build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvIcmpIdVer14(value);
        }
    }
}

