/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvEgressPortGroupId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvEgressPortGroupIdVer14
implements OFBsnTlvEgressPortGroupId {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvEgressPortGroupIdVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvEgressPortGroupIdVer14 DEFAULT = new OFBsnTlvEgressPortGroupIdVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvEgressPortGroupIdVer14Funnel FUNNEL = new OFBsnTlvEgressPortGroupIdVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvEgressPortGroupIdVer14(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 139;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvEgressPortGroupId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvEgressPortGroupIdVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvEgressPortGroupIdVer14 other = (OFBsnTlvEgressPortGroupIdVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvEgressPortGroupIdVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvEgressPortGroupIdVer14 message) {
            bb.writeShort(139);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvEgressPortGroupIdVer14Funnel
    implements Funnel<OFBsnTlvEgressPortGroupIdVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvEgressPortGroupIdVer14Funnel() {
        }

        public void funnel(OFBsnTlvEgressPortGroupIdVer14 message, PrimitiveSink sink) {
            sink.putShort((short)139);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvEgressPortGroupId> {
        Reader() {
        }

        @Override
        public OFBsnTlvEgressPortGroupId readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 139) {
                throw new OFParseError("Wrong type: Expected=0x8b(0x8b), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvEgressPortGroupIdVer14 bsnTlvEgressPortGroupIdVer14 = new OFBsnTlvEgressPortGroupIdVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvEgressPortGroupIdVer14);
            }
            return bsnTlvEgressPortGroupIdVer14;
        }
    }

    static class Builder
    implements OFBsnTlvEgressPortGroupId.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 139;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvEgressPortGroupId.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvEgressPortGroupId build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvEgressPortGroupIdVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvEgressPortGroupId.Builder {
        final OFBsnTlvEgressPortGroupIdVer14 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvEgressPortGroupIdVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 139;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvEgressPortGroupId.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvEgressPortGroupId build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvEgressPortGroupIdVer14(value);
        }
    }
}

