/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnTcpFlag;

public class OFBsnTcpFlagSerializerVer14 {
    public static final short BSN_TCP_FLAG_FIN_VAL = 1;
    public static final short BSN_TCP_FLAG_SYN_VAL = 2;
    public static final short BSN_TCP_FLAG_RST_VAL = 4;
    public static final short BSN_TCP_FLAG_PSH_VAL = 8;
    public static final short BSN_TCP_FLAG_ACK_VAL = 16;
    public static final short BSN_TCP_FLAG_URG_VAL = 32;
    public static final short BSN_TCP_FLAG_ECE_VAL = 64;
    public static final short BSN_TCP_FLAG_CWR_VAL = 128;
    public static final short BSN_TCP_FLAG_NS_VAL = 256;

    public static Set<OFBsnTcpFlag> readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFBsnTcpFlagSerializerVer14.ofWireValue(bb.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, Set<OFBsnTcpFlag> set) {
        bb.writeShort((int)OFBsnTcpFlagSerializerVer14.toWireValue(set));
    }

    public static void putTo(Set<OFBsnTcpFlag> set, PrimitiveSink sink) {
        sink.putShort(OFBsnTcpFlagSerializerVer14.toWireValue(set));
    }

    public static Set<OFBsnTcpFlag> ofWireValue(short val) {
        EnumSet<OFBsnTcpFlag> set = EnumSet.noneOf(OFBsnTcpFlag.class);
        if ((val & 1) != 0) {
            set.add(OFBsnTcpFlag.BSN_TCP_FLAG_FIN);
        }
        if ((val & 2) != 0) {
            set.add(OFBsnTcpFlag.BSN_TCP_FLAG_SYN);
        }
        if ((val & 4) != 0) {
            set.add(OFBsnTcpFlag.BSN_TCP_FLAG_RST);
        }
        if ((val & 8) != 0) {
            set.add(OFBsnTcpFlag.BSN_TCP_FLAG_PSH);
        }
        if ((val & 0x10) != 0) {
            set.add(OFBsnTcpFlag.BSN_TCP_FLAG_ACK);
        }
        if ((val & 0x20) != 0) {
            set.add(OFBsnTcpFlag.BSN_TCP_FLAG_URG);
        }
        if ((val & 0x40) != 0) {
            set.add(OFBsnTcpFlag.BSN_TCP_FLAG_ECE);
        }
        if ((val & 0x80) != 0) {
            set.add(OFBsnTcpFlag.BSN_TCP_FLAG_CWR);
        }
        if ((val & 0x100) != 0) {
            set.add(OFBsnTcpFlag.BSN_TCP_FLAG_NS);
        }
        return Collections.unmodifiableSet(set);
    }

    public static short toWireValue(Set<OFBsnTcpFlag> set) {
        short wireValue = 0;
        block11: for (OFBsnTcpFlag e : set) {
            switch (e) {
                case BSN_TCP_FLAG_FIN: {
                    wireValue = (short)(wireValue | 1);
                    continue block11;
                }
                case BSN_TCP_FLAG_SYN: {
                    wireValue = (short)(wireValue | 2);
                    continue block11;
                }
                case BSN_TCP_FLAG_RST: {
                    wireValue = (short)(wireValue | 4);
                    continue block11;
                }
                case BSN_TCP_FLAG_PSH: {
                    wireValue = (short)(wireValue | 8);
                    continue block11;
                }
                case BSN_TCP_FLAG_ACK: {
                    wireValue = (short)(wireValue | 0x10);
                    continue block11;
                }
                case BSN_TCP_FLAG_URG: {
                    wireValue = (short)(wireValue | 0x20);
                    continue block11;
                }
                case BSN_TCP_FLAG_ECE: {
                    wireValue = (short)(wireValue | 0x40);
                    continue block11;
                }
                case BSN_TCP_FLAG_CWR: {
                    wireValue = (short)(wireValue | 0x80);
                    continue block11;
                }
                case BSN_TCP_FLAG_NS: {
                    wireValue = (short)(wireValue | 0x100);
                    continue block11;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFBsnTcpFlag in version 1.4: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

