/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGetInterfacesRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGetInterfacesRequestVer14
implements OFBsnGetInterfacesRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGetInterfacesRequestVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    static final OFBsnGetInterfacesRequestVer14 DEFAULT = new OFBsnGetInterfacesRequestVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnGetInterfacesRequestVer14Funnel FUNNEL = new OFBsnGetInterfacesRequestVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGetInterfacesRequestVer14(long xid) {
        this.xid = xid;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 9L;
    }

    @Override
    public OFBsnGetInterfacesRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGetInterfacesRequestVer14(");
        b.append("xid=").append(this.xid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGetInterfacesRequestVer14 other = (OFBsnGetInterfacesRequestVer14)obj;
        return this.xid == other.xid;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGetInterfacesRequestVer14 other = (OFBsnGetInterfacesRequestVer14)obj;
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGetInterfacesRequestVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGetInterfacesRequestVer14 message) {
            bb.writeByte(5);
            bb.writeByte(4);
            bb.writeShort(16);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(9);
        }
    }

    static class OFBsnGetInterfacesRequestVer14Funnel
    implements Funnel<OFBsnGetInterfacesRequestVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnGetInterfacesRequestVer14Funnel() {
        }

        public void funnel(OFBsnGetInterfacesRequestVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)4);
            sink.putShort((short)16);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(9);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGetInterfacesRequest> {
        Reader() {
        }

        @Override
        public OFBsnGetInterfacesRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 9) {
                throw new OFParseError("Wrong subtype: Expected=0x9L(0x9L), got=" + subtype);
            }
            OFBsnGetInterfacesRequestVer14 bsnGetInterfacesRequestVer14 = new OFBsnGetInterfacesRequestVer14(xid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGetInterfacesRequestVer14);
            }
            return bsnGetInterfacesRequestVer14;
        }
    }

    static class Builder
    implements OFBsnGetInterfacesRequest.Builder {
        private boolean xidSet;
        private long xid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGetInterfacesRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 9L;
        }

        @Override
        public OFBsnGetInterfacesRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            return new OFBsnGetInterfacesRequestVer14(xid);
        }
    }

    static class BuilderWithParent
    implements OFBsnGetInterfacesRequest.Builder {
        final OFBsnGetInterfacesRequestVer14 parentMessage;
        private boolean xidSet;
        private long xid;

        BuilderWithParent(OFBsnGetInterfacesRequestVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGetInterfacesRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 9L;
        }

        @Override
        public OFBsnGetInterfacesRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            return new OFBsnGetInterfacesRequestVer14(xid);
        }
    }
}

