/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnDebugCounterStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnDebugCounterStatsEntryVer14
implements OFBsnDebugCounterStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnDebugCounterStatsEntryVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 16;
    private static final U64 DEFAULT_COUNTER_ID = U64.ZERO;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private final U64 counterId;
    private final U64 value;
    static final OFBsnDebugCounterStatsEntryVer14 DEFAULT = new OFBsnDebugCounterStatsEntryVer14(DEFAULT_COUNTER_ID, DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnDebugCounterStatsEntryVer14Funnel FUNNEL = new OFBsnDebugCounterStatsEntryVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnDebugCounterStatsEntryVer14(U64 counterId, U64 value) {
        if (counterId == null) {
            throw new NullPointerException("OFBsnDebugCounterStatsEntryVer14: property counterId cannot be null");
        }
        if (value == null) {
            throw new NullPointerException("OFBsnDebugCounterStatsEntryVer14: property value cannot be null");
        }
        this.counterId = counterId;
        this.value = value;
    }

    @Override
    public U64 getCounterId() {
        return this.counterId;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnDebugCounterStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnDebugCounterStatsEntryVer14(");
        b.append("counterId=").append(this.counterId);
        b.append(", ");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnDebugCounterStatsEntryVer14 other = (OFBsnDebugCounterStatsEntryVer14)obj;
        if (this.counterId == null ? other.counterId != null : !this.counterId.equals(other.counterId)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.counterId == null ? 0 : this.counterId.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnDebugCounterStatsEntryVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnDebugCounterStatsEntryVer14 message) {
            bb.writeLong(message.counterId.getValue());
            bb.writeLong(message.value.getValue());
        }
    }

    static class OFBsnDebugCounterStatsEntryVer14Funnel
    implements Funnel<OFBsnDebugCounterStatsEntryVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnDebugCounterStatsEntryVer14Funnel() {
        }

        public void funnel(OFBsnDebugCounterStatsEntryVer14 message, PrimitiveSink sink) {
            message.counterId.putTo(sink);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnDebugCounterStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnDebugCounterStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            U64 counterId = U64.ofRaw(bb.readLong());
            U64 value = U64.ofRaw(bb.readLong());
            OFBsnDebugCounterStatsEntryVer14 bsnDebugCounterStatsEntryVer14 = new OFBsnDebugCounterStatsEntryVer14(counterId, value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnDebugCounterStatsEntryVer14);
            }
            return bsnDebugCounterStatsEntryVer14;
        }
    }

    static class Builder
    implements OFBsnDebugCounterStatsEntry.Builder {
        private boolean counterIdSet;
        private U64 counterId;
        private boolean valueSet;
        private U64 value;

        Builder() {
        }

        @Override
        public U64 getCounterId() {
            return this.counterId;
        }

        @Override
        public OFBsnDebugCounterStatsEntry.Builder setCounterId(U64 counterId) {
            this.counterId = counterId;
            this.counterIdSet = true;
            return this;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnDebugCounterStatsEntry.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnDebugCounterStatsEntry build() {
            U64 value;
            U64 counterId;
            U64 u64 = counterId = this.counterIdSet ? this.counterId : DEFAULT_COUNTER_ID;
            if (counterId == null) {
                throw new NullPointerException("Property counterId must not be null");
            }
            U64 u642 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnDebugCounterStatsEntryVer14(counterId, value);
        }
    }

    static class BuilderWithParent
    implements OFBsnDebugCounterStatsEntry.Builder {
        final OFBsnDebugCounterStatsEntryVer14 parentMessage;
        private boolean counterIdSet;
        private U64 counterId;
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFBsnDebugCounterStatsEntryVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public U64 getCounterId() {
            return this.counterId;
        }

        @Override
        public OFBsnDebugCounterStatsEntry.Builder setCounterId(U64 counterId) {
            this.counterId = counterId;
            this.counterIdSet = true;
            return this;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnDebugCounterStatsEntry.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnDebugCounterStatsEntry build() {
            U64 value;
            U64 counterId;
            U64 u64 = counterId = this.counterIdSet ? this.counterId : this.parentMessage.counterId;
            if (counterId == null) {
                throw new NullPointerException("Property counterId must not be null");
            }
            U64 u642 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnDebugCounterStatsEntryVer14(counterId, value);
        }
    }
}

