/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnBwClearDataRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnBwClearDataRequestVer14
implements OFBsnBwClearDataRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnBwClearDataRequestVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    static final OFBsnBwClearDataRequestVer14 DEFAULT = new OFBsnBwClearDataRequestVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnBwClearDataRequestVer14Funnel FUNNEL = new OFBsnBwClearDataRequestVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnBwClearDataRequestVer14(long xid) {
        this.xid = xid;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 21L;
    }

    @Override
    public OFBsnBwClearDataRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnBwClearDataRequestVer14(");
        b.append("xid=").append(this.xid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnBwClearDataRequestVer14 other = (OFBsnBwClearDataRequestVer14)obj;
        return this.xid == other.xid;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnBwClearDataRequestVer14 other = (OFBsnBwClearDataRequestVer14)obj;
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnBwClearDataRequestVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnBwClearDataRequestVer14 message) {
            bb.writeByte(5);
            bb.writeByte(4);
            bb.writeShort(16);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(21);
        }
    }

    static class OFBsnBwClearDataRequestVer14Funnel
    implements Funnel<OFBsnBwClearDataRequestVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnBwClearDataRequestVer14Funnel() {
        }

        public void funnel(OFBsnBwClearDataRequestVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)4);
            sink.putShort((short)16);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(21);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnBwClearDataRequest> {
        Reader() {
        }

        @Override
        public OFBsnBwClearDataRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 21) {
                throw new OFParseError("Wrong subtype: Expected=0x15L(0x15L), got=" + subtype);
            }
            OFBsnBwClearDataRequestVer14 bsnBwClearDataRequestVer14 = new OFBsnBwClearDataRequestVer14(xid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnBwClearDataRequestVer14);
            }
            return bsnBwClearDataRequestVer14;
        }
    }

    static class Builder
    implements OFBsnBwClearDataRequest.Builder {
        private boolean xidSet;
        private long xid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnBwClearDataRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 21L;
        }

        @Override
        public OFBsnBwClearDataRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            return new OFBsnBwClearDataRequestVer14(xid);
        }
    }

    static class BuilderWithParent
    implements OFBsnBwClearDataRequest.Builder {
        final OFBsnBwClearDataRequestVer14 parentMessage;
        private boolean xidSet;
        private long xid;

        BuilderWithParent(OFBsnBwClearDataRequestVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnBwClearDataRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 21L;
        }

        @Override
        public OFBsnBwClearDataRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            return new OFBsnBwClearDataRequestVer14(xid);
        }
    }
}

