/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncConfigProp;
import org.projectfloodlight.openflow.protocol.OFAsyncGetReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFAsyncConfigPropVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncGetReplyVer14
implements OFAsyncGetReply {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncGetReplyVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 8;
    private static final long DEFAULT_XID = 0L;
    private static final List<OFAsyncConfigProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final long xid;
    private final List<OFAsyncConfigProp> properties;
    static final OFAsyncGetReplyVer14 DEFAULT = new OFAsyncGetReplyVer14(0L, DEFAULT_PROPERTIES);
    static final Reader READER = new Reader();
    static final OFAsyncGetReplyVer14Funnel FUNNEL = new OFAsyncGetReplyVer14Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncGetReplyVer14(long xid, List<OFAsyncConfigProp> properties) {
        if (properties == null) {
            throw new NullPointerException("OFAsyncGetReplyVer14: property properties cannot be null");
        }
        this.xid = xid;
        this.properties = properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.GET_ASYNC_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getPacketInMaskEqualMaster() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property packetInMaskEqualMaster not supported in version 1.4");
    }

    @Override
    public long getPacketInMaskSlave() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property packetInMaskSlave not supported in version 1.4");
    }

    @Override
    public long getPortStatusMaskEqualMaster() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property portStatusMaskEqualMaster not supported in version 1.4");
    }

    @Override
    public long getPortStatusMaskSlave() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property portStatusMaskSlave not supported in version 1.4");
    }

    @Override
    public long getFlowRemovedMaskEqualMaster() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property flowRemovedMaskEqualMaster not supported in version 1.4");
    }

    @Override
    public long getFlowRemovedMaskSlave() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property flowRemovedMaskSlave not supported in version 1.4");
    }

    @Override
    public List<OFAsyncConfigProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFAsyncGetReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncGetReplyVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncGetReplyVer14 other = (OFAsyncGetReplyVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncGetReplyVer14 other = (OFAsyncGetReplyVer14)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncGetReplyVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAsyncGetReplyVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(5);
            bb.writeByte(27);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFAsyncGetReplyVer14Funnel
    implements Funnel<OFAsyncGetReplyVer14> {
        private static final long serialVersionUID = 1L;

        OFAsyncGetReplyVer14Funnel() {
        }

        public void funnel(OFAsyncGetReplyVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)27);
            sink.putLong(message.xid);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncGetReply> {
        Reader() {
        }

        @Override
        public OFAsyncGetReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 27) {
                throw new OFParseError("Wrong type: Expected=OFType.GET_ASYNC_REPLY(27), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            List<OFAsyncConfigProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFAsyncConfigPropVer14.READER);
            OFAsyncGetReplyVer14 asyncGetReplyVer14 = new OFAsyncGetReplyVer14(xid, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncGetReplyVer14);
            }
            return asyncGetReplyVer14;
        }
    }

    static class Builder
    implements OFAsyncGetReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean propertiesSet;
        private List<OFAsyncConfigProp> properties;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.GET_ASYNC_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAsyncGetReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getPacketInMaskEqualMaster() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetInMaskEqualMaster not supported in version 1.4");
        }

        @Override
        public OFAsyncGetReply.Builder setPacketInMaskEqualMaster(long packetInMaskEqualMaster) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetInMaskEqualMaster not supported in version 1.4");
        }

        @Override
        public long getPacketInMaskSlave() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetInMaskSlave not supported in version 1.4");
        }

        @Override
        public OFAsyncGetReply.Builder setPacketInMaskSlave(long packetInMaskSlave) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetInMaskSlave not supported in version 1.4");
        }

        @Override
        public long getPortStatusMaskEqualMaster() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portStatusMaskEqualMaster not supported in version 1.4");
        }

        @Override
        public OFAsyncGetReply.Builder setPortStatusMaskEqualMaster(long portStatusMaskEqualMaster) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portStatusMaskEqualMaster not supported in version 1.4");
        }

        @Override
        public long getPortStatusMaskSlave() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portStatusMaskSlave not supported in version 1.4");
        }

        @Override
        public OFAsyncGetReply.Builder setPortStatusMaskSlave(long portStatusMaskSlave) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portStatusMaskSlave not supported in version 1.4");
        }

        @Override
        public long getFlowRemovedMaskEqualMaster() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowRemovedMaskEqualMaster not supported in version 1.4");
        }

        @Override
        public OFAsyncGetReply.Builder setFlowRemovedMaskEqualMaster(long flowRemovedMaskEqualMaster) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowRemovedMaskEqualMaster not supported in version 1.4");
        }

        @Override
        public long getFlowRemovedMaskSlave() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowRemovedMaskSlave not supported in version 1.4");
        }

        @Override
        public OFAsyncGetReply.Builder setFlowRemovedMaskSlave(long flowRemovedMaskSlave) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowRemovedMaskSlave not supported in version 1.4");
        }

        @Override
        public List<OFAsyncConfigProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFAsyncGetReply.Builder setProperties(List<OFAsyncConfigProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFAsyncGetReply build() {
            List<OFAsyncConfigProp> properties;
            long xid = this.xidSet ? this.xid : 0L;
            List<OFAsyncConfigProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFAsyncGetReplyVer14(xid, properties);
        }
    }

    static class BuilderWithParent
    implements OFAsyncGetReply.Builder {
        final OFAsyncGetReplyVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean propertiesSet;
        private List<OFAsyncConfigProp> properties;

        BuilderWithParent(OFAsyncGetReplyVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.GET_ASYNC_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAsyncGetReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getPacketInMaskEqualMaster() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetInMaskEqualMaster not supported in version 1.4");
        }

        @Override
        public OFAsyncGetReply.Builder setPacketInMaskEqualMaster(long packetInMaskEqualMaster) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetInMaskEqualMaster not supported in version 1.4");
        }

        @Override
        public long getPacketInMaskSlave() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetInMaskSlave not supported in version 1.4");
        }

        @Override
        public OFAsyncGetReply.Builder setPacketInMaskSlave(long packetInMaskSlave) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetInMaskSlave not supported in version 1.4");
        }

        @Override
        public long getPortStatusMaskEqualMaster() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portStatusMaskEqualMaster not supported in version 1.4");
        }

        @Override
        public OFAsyncGetReply.Builder setPortStatusMaskEqualMaster(long portStatusMaskEqualMaster) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portStatusMaskEqualMaster not supported in version 1.4");
        }

        @Override
        public long getPortStatusMaskSlave() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portStatusMaskSlave not supported in version 1.4");
        }

        @Override
        public OFAsyncGetReply.Builder setPortStatusMaskSlave(long portStatusMaskSlave) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portStatusMaskSlave not supported in version 1.4");
        }

        @Override
        public long getFlowRemovedMaskEqualMaster() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowRemovedMaskEqualMaster not supported in version 1.4");
        }

        @Override
        public OFAsyncGetReply.Builder setFlowRemovedMaskEqualMaster(long flowRemovedMaskEqualMaster) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowRemovedMaskEqualMaster not supported in version 1.4");
        }

        @Override
        public long getFlowRemovedMaskSlave() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowRemovedMaskSlave not supported in version 1.4");
        }

        @Override
        public OFAsyncGetReply.Builder setFlowRemovedMaskSlave(long flowRemovedMaskSlave) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowRemovedMaskSlave not supported in version 1.4");
        }

        @Override
        public List<OFAsyncConfigProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFAsyncGetReply.Builder setProperties(List<OFAsyncConfigProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFAsyncGetReply build() {
            List properties;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFAsyncGetReplyVer14(xid, properties);
        }
    }
}

