/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFErrorType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortModFailedCode;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFPortModFailedErrorMsg;
import org.projectfloodlight.openflow.protocol.ver13.OFPortModFailedCodeSerializerVer13;
import org.projectfloodlight.openflow.types.OFErrorCauseData;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortModFailedErrorMsgVer13
implements OFPortModFailedErrorMsg {
    private static final Logger logger = LoggerFactory.getLogger(OFPortModFailedErrorMsgVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 12;
    private static final long DEFAULT_XID = 0L;
    private static final OFErrorCauseData DEFAULT_DATA = OFErrorCauseData.NONE;
    private final long xid;
    private final OFPortModFailedCode code;
    private final OFErrorCauseData data;
    static final Reader READER = new Reader();
    static final OFPortModFailedErrorMsgVer13Funnel FUNNEL = new OFPortModFailedErrorMsgVer13Funnel();
    static final Writer WRITER = new Writer();

    OFPortModFailedErrorMsgVer13(long xid, OFPortModFailedCode code, OFErrorCauseData data) {
        if (code == null) {
            throw new NullPointerException("OFPortModFailedErrorMsgVer13: property code cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("OFPortModFailedErrorMsgVer13: property data cannot be null");
        }
        this.xid = xid;
        this.code = code;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.ERROR;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFErrorType getErrType() {
        return OFErrorType.PORT_MOD_FAILED;
    }

    @Override
    public OFPortModFailedCode getCode() {
        return this.code;
    }

    @Override
    public OFErrorCauseData getData() {
        return this.data;
    }

    @Override
    public OFPortModFailedErrorMsg.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortModFailedErrorMsgVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("code=").append((Object)this.code);
        b.append(", ");
        b.append("data=").append(this.data);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortModFailedErrorMsgVer13 other = (OFPortModFailedErrorMsgVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.code == null ? other.code != null : !this.code.equals((Object)other.code)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortModFailedErrorMsgVer13 other = (OFPortModFailedErrorMsgVer13)obj;
        if (this.code == null ? other.code != null : !this.code.equals((Object)other.code)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortModFailedErrorMsgVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortModFailedErrorMsgVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(7);
            OFPortModFailedCodeSerializerVer13.writeTo(bb, message.code);
            message.data.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPortModFailedErrorMsgVer13Funnel
    implements Funnel<OFPortModFailedErrorMsgVer13> {
        private static final long serialVersionUID = 1L;

        OFPortModFailedErrorMsgVer13Funnel() {
        }

        public void funnel(OFPortModFailedErrorMsgVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)1);
            sink.putLong(message.xid);
            sink.putShort((short)7);
            OFPortModFailedCodeSerializerVer13.putTo(message.code, sink);
            message.data.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortModFailedErrorMsg> {
        Reader() {
        }

        @Override
        public OFPortModFailedErrorMsg readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short errType = bb.readShort();
            if (errType != 7) {
                throw new OFParseError("Wrong errType: Expected=OFErrorType.PORT_MOD_FAILED(7), got=" + errType);
            }
            OFPortModFailedCode code = OFPortModFailedCodeSerializerVer13.readFrom(bb);
            OFErrorCauseData data = OFErrorCauseData.read(bb, length - (bb.readerIndex() - start), OFVersion.OF_13);
            OFPortModFailedErrorMsgVer13 portModFailedErrorMsgVer13 = new OFPortModFailedErrorMsgVer13(xid, code, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portModFailedErrorMsgVer13);
            }
            return portModFailedErrorMsgVer13;
        }
    }

    static class Builder
    implements OFPortModFailedErrorMsg.Builder {
        private boolean xidSet;
        private long xid;
        private boolean codeSet;
        private OFPortModFailedCode code;
        private boolean dataSet;
        private OFErrorCauseData data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.ERROR;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortModFailedErrorMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFErrorType getErrType() {
            return OFErrorType.PORT_MOD_FAILED;
        }

        @Override
        public OFPortModFailedCode getCode() {
            return this.code;
        }

        @Override
        public OFPortModFailedErrorMsg.Builder setCode(OFPortModFailedCode code) {
            this.code = code;
            this.codeSet = true;
            return this;
        }

        @Override
        public OFErrorCauseData getData() {
            return this.data;
        }

        @Override
        public OFPortModFailedErrorMsg.Builder setData(OFErrorCauseData data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFPortModFailedErrorMsg build() {
            OFErrorCauseData data;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.codeSet) {
                throw new IllegalStateException("Property code doesn't have default value -- must be set");
            }
            if (this.code == null) {
                throw new NullPointerException("Property code must not be null");
            }
            OFErrorCauseData oFErrorCauseData = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFPortModFailedErrorMsgVer13(xid, this.code, data);
        }
    }

    static class BuilderWithParent
    implements OFPortModFailedErrorMsg.Builder {
        final OFPortModFailedErrorMsgVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean codeSet;
        private OFPortModFailedCode code;
        private boolean dataSet;
        private OFErrorCauseData data;

        BuilderWithParent(OFPortModFailedErrorMsgVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.ERROR;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortModFailedErrorMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFErrorType getErrType() {
            return OFErrorType.PORT_MOD_FAILED;
        }

        @Override
        public OFPortModFailedCode getCode() {
            return this.code;
        }

        @Override
        public OFPortModFailedErrorMsg.Builder setCode(OFPortModFailedCode code) {
            this.code = code;
            this.codeSet = true;
            return this;
        }

        @Override
        public OFErrorCauseData getData() {
            return this.data;
        }

        @Override
        public OFPortModFailedErrorMsg.Builder setData(OFErrorCauseData data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFPortModFailedErrorMsg build() {
            OFErrorCauseData data;
            OFPortModFailedCode code;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFPortModFailedCode oFPortModFailedCode = code = this.codeSet ? this.code : this.parentMessage.code;
            if (code == null) {
                throw new NullPointerException("Property code must not be null");
            }
            OFErrorCauseData oFErrorCauseData = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFPortModFailedErrorMsgVer13(xid, code, data);
        }
    }
}

