/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnVrfMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmBsnVrfVer13;
import org.projectfloodlight.openflow.types.VRF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnVrfMaskedVer13
implements OFOxmBsnVrfMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnVrfMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 12;
    private static final VRF DEFAULT_VALUE = VRF.ZERO;
    private static final VRF DEFAULT_VALUE_MASK = VRF.ZERO;
    private final VRF value;
    private final VRF mask;
    static final OFOxmBsnVrfMaskedVer13 DEFAULT = new OFOxmBsnVrfMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmBsnVrfMaskedVer13Funnel FUNNEL = new OFOxmBsnVrfMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnVrfMaskedVer13(VRF value, VRF mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnVrfMaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmBsnVrfMaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 197896L;
    }

    @Override
    public VRF getValue() {
        return this.value;
    }

    @Override
    public VRF getMask() {
        return this.mask;
    }

    @Override
    public MatchField<VRF> getMatchField() {
        return MatchField.BSN_VRF;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<VRF> getCanonical() {
        if (VRF.NO_MASK.equals(this.mask)) {
            return new OFOxmBsnVrfVer13(this.value);
        }
        if (VRF.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmBsnVrfMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnVrfMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnVrfMaskedVer13 other = (OFOxmBsnVrfMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnVrfMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnVrfMaskedVer13 message) {
            bb.writeInt(197896);
            message.value.write4Bytes(bb);
            message.mask.write4Bytes(bb);
        }
    }

    static class OFOxmBsnVrfMaskedVer13Funnel
    implements Funnel<OFOxmBsnVrfMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnVrfMaskedVer13Funnel() {
        }

        public void funnel(OFOxmBsnVrfMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(197896);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnVrfMasked> {
        Reader() {
        }

        @Override
        public OFOxmBsnVrfMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 197896) {
                throw new OFParseError("Wrong typeLen: Expected=0x30508L(0x30508L), got=" + typeLen);
            }
            VRF value = VRF.read4Bytes(bb);
            VRF mask = VRF.read4Bytes(bb);
            OFOxmBsnVrfMaskedVer13 oxmBsnVrfMaskedVer13 = new OFOxmBsnVrfMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnVrfMaskedVer13);
            }
            return oxmBsnVrfMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmBsnVrfMasked.Builder {
        private boolean valueSet;
        private VRF value;
        private boolean maskSet;
        private VRF mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 197896L;
        }

        @Override
        public VRF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVrfMasked.Builder setValue(VRF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public VRF getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnVrfMasked.Builder setMask(VRF mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<VRF> getMatchField() {
            return MatchField.BSN_VRF;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<VRF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnVrfMasked build() {
            VRF mask;
            VRF value;
            VRF vRF = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            VRF vRF2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnVrfMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnVrfMasked.Builder {
        final OFOxmBsnVrfMaskedVer13 parentMessage;
        private boolean valueSet;
        private VRF value;
        private boolean maskSet;
        private VRF mask;

        BuilderWithParent(OFOxmBsnVrfMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 197896L;
        }

        @Override
        public VRF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVrfMasked.Builder setValue(VRF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public VRF getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnVrfMasked.Builder setMask(VRF mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<VRF> getMatchField() {
            return MatchField.BSN_VRF;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<VRF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnVrfMasked build() {
            VRF mask;
            VRF value;
            VRF vRF = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            VRF vRF2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnVrfMaskedVer13(value, mask);
        }
    }
}

