/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.meterband.OFMeterBandDscpRemark;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMeterBandDscpRemarkVer13
implements OFMeterBandDscpRemark {
    private static final Logger logger = LoggerFactory.getLogger(OFMeterBandDscpRemarkVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 16;
    private static final long DEFAULT_RATE = 0L;
    private static final long DEFAULT_BURST_SIZE = 0L;
    private static final short DEFAULT_PREC_LEVEL = 0;
    private final long rate;
    private final long burstSize;
    private final short precLevel;
    static final OFMeterBandDscpRemarkVer13 DEFAULT = new OFMeterBandDscpRemarkVer13(0L, 0L, 0);
    static final Reader READER = new Reader();
    static final OFMeterBandDscpRemarkVer13Funnel FUNNEL = new OFMeterBandDscpRemarkVer13Funnel();
    static final Writer WRITER = new Writer();

    OFMeterBandDscpRemarkVer13(long rate, long burstSize, short precLevel) {
        this.rate = rate;
        this.burstSize = burstSize;
        this.precLevel = precLevel;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public long getRate() {
        return this.rate;
    }

    @Override
    public long getBurstSize() {
        return this.burstSize;
    }

    @Override
    public short getPrecLevel() {
        return this.precLevel;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFMeterBandDscpRemark.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMeterBandDscpRemarkVer13(");
        b.append("rate=").append(this.rate);
        b.append(", ");
        b.append("burstSize=").append(this.burstSize);
        b.append(", ");
        b.append("precLevel=").append(this.precLevel);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterBandDscpRemarkVer13 other = (OFMeterBandDscpRemarkVer13)obj;
        if (this.rate != other.rate) {
            return false;
        }
        if (this.burstSize != other.burstSize) {
            return false;
        }
        return this.precLevel == other.precLevel;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.rate ^ this.rate >>> 32);
        result = 31 * (int)(this.burstSize ^ this.burstSize >>> 32);
        result = 31 * result + this.precLevel;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMeterBandDscpRemarkVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFMeterBandDscpRemarkVer13 message) {
            bb.writeShort(2);
            bb.writeShort(16);
            bb.writeInt(U32.t(message.rate));
            bb.writeInt(U32.t(message.burstSize));
            bb.writeByte((int)U8.t(message.precLevel));
            bb.writeZero(3);
        }
    }

    static class OFMeterBandDscpRemarkVer13Funnel
    implements Funnel<OFMeterBandDscpRemarkVer13> {
        private static final long serialVersionUID = 1L;

        OFMeterBandDscpRemarkVer13Funnel() {
        }

        public void funnel(OFMeterBandDscpRemarkVer13 message, PrimitiveSink sink) {
            sink.putShort((short)2);
            sink.putShort((short)16);
            sink.putLong(message.rate);
            sink.putLong(message.burstSize);
            sink.putShort(message.precLevel);
        }
    }

    static class Reader
    implements OFMessageReader<OFMeterBandDscpRemark> {
        Reader() {
        }

        @Override
        public OFMeterBandDscpRemark readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 2) {
                throw new OFParseError("Wrong type: Expected=0x2(0x2), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long rate = U32.f(bb.readInt());
            long burstSize = U32.f(bb.readInt());
            short precLevel = U8.f(bb.readByte());
            bb.skipBytes(3);
            OFMeterBandDscpRemarkVer13 meterBandDscpRemarkVer13 = new OFMeterBandDscpRemarkVer13(rate, burstSize, precLevel);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)meterBandDscpRemarkVer13);
            }
            return meterBandDscpRemarkVer13;
        }
    }

    static class Builder
    implements OFMeterBandDscpRemark.Builder {
        private boolean rateSet;
        private long rate;
        private boolean burstSizeSet;
        private long burstSize;
        private boolean precLevelSet;
        private short precLevel;

        Builder() {
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public long getRate() {
            return this.rate;
        }

        @Override
        public OFMeterBandDscpRemark.Builder setRate(long rate) {
            this.rate = rate;
            this.rateSet = true;
            return this;
        }

        @Override
        public long getBurstSize() {
            return this.burstSize;
        }

        @Override
        public OFMeterBandDscpRemark.Builder setBurstSize(long burstSize) {
            this.burstSize = burstSize;
            this.burstSizeSet = true;
            return this;
        }

        @Override
        public short getPrecLevel() {
            return this.precLevel;
        }

        @Override
        public OFMeterBandDscpRemark.Builder setPrecLevel(short precLevel) {
            this.precLevel = precLevel;
            this.precLevelSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFMeterBandDscpRemark build() {
            long rate = this.rateSet ? this.rate : 0L;
            long burstSize = this.burstSizeSet ? this.burstSize : 0L;
            short precLevel = this.precLevelSet ? this.precLevel : (short)0;
            return new OFMeterBandDscpRemarkVer13(rate, burstSize, precLevel);
        }
    }

    static class BuilderWithParent
    implements OFMeterBandDscpRemark.Builder {
        final OFMeterBandDscpRemarkVer13 parentMessage;
        private boolean rateSet;
        private long rate;
        private boolean burstSizeSet;
        private long burstSize;
        private boolean precLevelSet;
        private short precLevel;

        BuilderWithParent(OFMeterBandDscpRemarkVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public long getRate() {
            return this.rate;
        }

        @Override
        public OFMeterBandDscpRemark.Builder setRate(long rate) {
            this.rate = rate;
            this.rateSet = true;
            return this;
        }

        @Override
        public long getBurstSize() {
            return this.burstSize;
        }

        @Override
        public OFMeterBandDscpRemark.Builder setBurstSize(long burstSize) {
            this.burstSize = burstSize;
            this.burstSizeSet = true;
            return this;
        }

        @Override
        public short getPrecLevel() {
            return this.precLevel;
        }

        @Override
        public OFMeterBandDscpRemark.Builder setPrecLevel(short precLevel) {
            this.precLevel = precLevel;
            this.precLevelSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFMeterBandDscpRemark build() {
            long rate = this.rateSet ? this.rate : this.parentMessage.rate;
            long burstSize = this.burstSizeSet ? this.burstSize : this.parentMessage.burstSize;
            short precLevel = this.precLevelSet ? this.precLevel : this.parentMessage.precLevel;
            return new OFMeterBandDscpRemarkVer13(rate, burstSize, precLevel);
        }
    }
}

