/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instructionid.OFInstructionIdBsnHashSelect;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionIdBsnHashSelectVer13
implements OFInstructionIdBsnHashSelect {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionIdBsnHashSelectVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 12;
    static final OFInstructionIdBsnHashSelectVer13 DEFAULT = new OFInstructionIdBsnHashSelectVer13();
    static final OFInstructionIdBsnHashSelectVer13 INSTANCE = new OFInstructionIdBsnHashSelectVer13();
    static final Reader READER = new Reader();
    static final OFInstructionIdBsnHashSelectVer13Funnel FUNNEL = new OFInstructionIdBsnHashSelectVer13Funnel();
    static final Writer WRITER = new Writer();

    private OFInstructionIdBsnHashSelectVer13() {
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 15L;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFInstructionIdBsnHashSelect.Builder createBuilder() {
        throw new UnsupportedOperationException("OFInstructionIdBsnHashSelectVer13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionIdBsnHashSelectVer13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionIdBsnHashSelectVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFInstructionIdBsnHashSelectVer13 message) {
            bb.writeShort(-1);
            bb.writeShort(12);
            bb.writeInt(6035143);
            bb.writeInt(15);
        }
    }

    static class OFInstructionIdBsnHashSelectVer13Funnel
    implements Funnel<OFInstructionIdBsnHashSelectVer13> {
        private static final long serialVersionUID = 1L;

        OFInstructionIdBsnHashSelectVer13Funnel() {
        }

        public void funnel(OFInstructionIdBsnHashSelectVer13 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)12);
            sink.putInt(6035143);
            sink.putInt(15);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionIdBsnHashSelect> {
        Reader() {
        }

        @Override
        public OFInstructionIdBsnHashSelect readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 15) {
                throw new OFParseError("Wrong subtype: Expected=0xfL(0xfL), got=" + subtype);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

