/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnVlanCounterStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnVlanCounterStatsEntryVer13
implements OFBsnVlanCounterStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnVlanCounterStatsEntryVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 8;
    private static final int DEFAULT_VLAN_VID = 0;
    private static final List<U64> DEFAULT_VALUES = ImmutableList.of();
    private final int vlanVid;
    private final List<U64> values;
    static final OFBsnVlanCounterStatsEntryVer13 DEFAULT = new OFBsnVlanCounterStatsEntryVer13(0, DEFAULT_VALUES);
    static final Reader READER = new Reader();
    static final OFBsnVlanCounterStatsEntryVer13Funnel FUNNEL = new OFBsnVlanCounterStatsEntryVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnVlanCounterStatsEntryVer13(int vlanVid, List<U64> values) {
        if (values == null) {
            throw new NullPointerException("OFBsnVlanCounterStatsEntryVer13: property values cannot be null");
        }
        this.vlanVid = vlanVid;
        this.values = values;
    }

    @Override
    public int getVlanVid() {
        return this.vlanVid;
    }

    @Override
    public List<U64> getValues() {
        return this.values;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnVlanCounterStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnVlanCounterStatsEntryVer13(");
        b.append("vlanVid=").append(this.vlanVid);
        b.append(", ");
        b.append("values=").append(this.values);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnVlanCounterStatsEntryVer13 other = (OFBsnVlanCounterStatsEntryVer13)obj;
        if (this.vlanVid != other.vlanVid) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.vlanVid;
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnVlanCounterStatsEntryVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnVlanCounterStatsEntryVer13 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeShort((int)U16.t(message.vlanVid));
            bb.writeZero(4);
            ChannelUtils.writeList(bb, message.values);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnVlanCounterStatsEntryVer13Funnel
    implements Funnel<OFBsnVlanCounterStatsEntryVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnVlanCounterStatsEntryVer13Funnel() {
        }

        public void funnel(OFBsnVlanCounterStatsEntryVer13 message, PrimitiveSink sink) {
            sink.putInt(message.vlanVid);
            FunnelUtils.putList(message.values, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnVlanCounterStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnVlanCounterStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int vlanVid = U16.f(bb.readShort());
            bb.skipBytes(4);
            List<U64> values = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U64.READER);
            OFBsnVlanCounterStatsEntryVer13 bsnVlanCounterStatsEntryVer13 = new OFBsnVlanCounterStatsEntryVer13(vlanVid, values);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnVlanCounterStatsEntryVer13);
            }
            return bsnVlanCounterStatsEntryVer13;
        }
    }

    static class Builder
    implements OFBsnVlanCounterStatsEntry.Builder {
        private boolean vlanVidSet;
        private int vlanVid;
        private boolean valuesSet;
        private List<U64> values;

        Builder() {
        }

        @Override
        public int getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFBsnVlanCounterStatsEntry.Builder setVlanVid(int vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public List<U64> getValues() {
            return this.values;
        }

        @Override
        public OFBsnVlanCounterStatsEntry.Builder setValues(List<U64> values) {
            this.values = values;
            this.valuesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnVlanCounterStatsEntry build() {
            List<U64> values;
            int vlanVid = this.vlanVidSet ? this.vlanVid : 0;
            List<U64> list = values = this.valuesSet ? this.values : DEFAULT_VALUES;
            if (values == null) {
                throw new NullPointerException("Property values must not be null");
            }
            return new OFBsnVlanCounterStatsEntryVer13(vlanVid, values);
        }
    }

    static class BuilderWithParent
    implements OFBsnVlanCounterStatsEntry.Builder {
        final OFBsnVlanCounterStatsEntryVer13 parentMessage;
        private boolean vlanVidSet;
        private int vlanVid;
        private boolean valuesSet;
        private List<U64> values;

        BuilderWithParent(OFBsnVlanCounterStatsEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFBsnVlanCounterStatsEntry.Builder setVlanVid(int vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public List<U64> getValues() {
            return this.values;
        }

        @Override
        public OFBsnVlanCounterStatsEntry.Builder setValues(List<U64> values) {
            this.values = values;
            this.valuesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnVlanCounterStatsEntry build() {
            List values;
            int vlanVid = this.vlanVidSet ? this.vlanVid : this.parentMessage.vlanVid;
            List list = values = this.valuesSet ? this.values : this.parentMessage.values;
            if (values == null) {
                throw new NullPointerException("Property values must not be null");
            }
            return new OFBsnVlanCounterStatsEntryVer13(vlanVid, values);
        }
    }
}

