/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvMplsLabel;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvMplsLabelVer13
implements OFBsnTlvMplsLabel {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvMplsLabelVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvMplsLabelVer13 DEFAULT = new OFBsnTlvMplsLabelVer13(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvMplsLabelVer13Funnel FUNNEL = new OFBsnTlvMplsLabelVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvMplsLabelVer13(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 61;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvMplsLabel.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvMplsLabelVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvMplsLabelVer13 other = (OFBsnTlvMplsLabelVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvMplsLabelVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvMplsLabelVer13 message) {
            bb.writeShort(61);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvMplsLabelVer13Funnel
    implements Funnel<OFBsnTlvMplsLabelVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvMplsLabelVer13Funnel() {
        }

        public void funnel(OFBsnTlvMplsLabelVer13 message, PrimitiveSink sink) {
            sink.putShort((short)61);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvMplsLabel> {
        Reader() {
        }

        @Override
        public OFBsnTlvMplsLabel readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 61) {
                throw new OFParseError("Wrong type: Expected=0x3d(0x3d), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvMplsLabelVer13 bsnTlvMplsLabelVer13 = new OFBsnTlvMplsLabelVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvMplsLabelVer13);
            }
            return bsnTlvMplsLabelVer13;
        }
    }

    static class Builder
    implements OFBsnTlvMplsLabel.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 61;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMplsLabel.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvMplsLabel build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvMplsLabelVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvMplsLabel.Builder {
        final OFBsnTlvMplsLabelVer13 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvMplsLabelVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 61;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMplsLabel.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvMplsLabel build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvMplsLabelVer13(value);
        }
    }
}

