/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvApplyBytes;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvApplyBytesVer13
implements OFBsnTlvApplyBytes {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvApplyBytesVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 12;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private final U64 value;
    static final OFBsnTlvApplyBytesVer13 DEFAULT = new OFBsnTlvApplyBytesVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvApplyBytesVer13Funnel FUNNEL = new OFBsnTlvApplyBytesVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvApplyBytesVer13(U64 value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvApplyBytesVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 130;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvApplyBytes.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvApplyBytesVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvApplyBytesVer13 other = (OFBsnTlvApplyBytesVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvApplyBytesVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvApplyBytesVer13 message) {
            bb.writeShort(130);
            bb.writeShort(12);
            bb.writeLong(message.value.getValue());
        }
    }

    static class OFBsnTlvApplyBytesVer13Funnel
    implements Funnel<OFBsnTlvApplyBytesVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvApplyBytesVer13Funnel() {
        }

        public void funnel(OFBsnTlvApplyBytesVer13 message, PrimitiveSink sink) {
            sink.putShort((short)130);
            sink.putShort((short)12);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvApplyBytes> {
        Reader() {
        }

        @Override
        public OFBsnTlvApplyBytes readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 130) {
                throw new OFParseError("Wrong type: Expected=0x82(0x82), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            U64 value = U64.ofRaw(bb.readLong());
            OFBsnTlvApplyBytesVer13 bsnTlvApplyBytesVer13 = new OFBsnTlvApplyBytesVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvApplyBytesVer13);
            }
            return bsnTlvApplyBytesVer13;
        }
    }

    static class Builder
    implements OFBsnTlvApplyBytes.Builder {
        private boolean valueSet;
        private U64 value;

        Builder() {
        }

        @Override
        public int getType() {
            return 130;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvApplyBytes.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvApplyBytes build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvApplyBytesVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvApplyBytes.Builder {
        final OFBsnTlvApplyBytesVer13 parentMessage;
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFBsnTlvApplyBytesVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 130;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvApplyBytes.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvApplyBytes build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvApplyBytesVer13(value);
        }
    }
}

