/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvActorKey;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvActorKeyVer13
implements OFBsnTlvActorKey {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvActorKeyVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvActorKeyVer13 DEFAULT = new OFBsnTlvActorKeyVer13(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvActorKeyVer13Funnel FUNNEL = new OFBsnTlvActorKeyVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvActorKeyVer13(int value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 44;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvActorKey.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvActorKeyVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvActorKeyVer13 other = (OFBsnTlvActorKeyVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvActorKeyVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvActorKeyVer13 message) {
            bb.writeShort(44);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvActorKeyVer13Funnel
    implements Funnel<OFBsnTlvActorKeyVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvActorKeyVer13Funnel() {
        }

        public void funnel(OFBsnTlvActorKeyVer13 message, PrimitiveSink sink) {
            sink.putShort((short)44);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvActorKey> {
        Reader() {
        }

        @Override
        public OFBsnTlvActorKey readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 44) {
                throw new OFParseError("Wrong type: Expected=0x2c(0x2c), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvActorKeyVer13 bsnTlvActorKeyVer13 = new OFBsnTlvActorKeyVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvActorKeyVer13);
            }
            return bsnTlvActorKeyVer13;
        }
    }

    static class Builder
    implements OFBsnTlvActorKey.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 44;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvActorKey.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvActorKey build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvActorKeyVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvActorKey.Builder {
        final OFBsnTlvActorKeyVer13 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvActorKeyVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 44;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvActorKey.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvActorKey build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvActorKeyVer13(value);
        }
    }
}

