/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGentableClearRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.GenTableId;
import org.projectfloodlight.openflow.types.U128;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGentableClearRequestVer13
implements OFBsnGentableClearRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGentableClearRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 52;
    private static final long DEFAULT_XID = 0L;
    private static final U128 DEFAULT_CHECKSUM = U128.ZERO;
    private static final U128 DEFAULT_CHECKSUM_MASK = U128.ZERO;
    private final long xid;
    private final GenTableId tableId;
    private final U128 checksum;
    private final U128 checksumMask;
    static final Reader READER = new Reader();
    static final OFBsnGentableClearRequestVer13Funnel FUNNEL = new OFBsnGentableClearRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGentableClearRequestVer13(long xid, GenTableId tableId, U128 checksum, U128 checksumMask) {
        if (tableId == null) {
            throw new NullPointerException("OFBsnGentableClearRequestVer13: property tableId cannot be null");
        }
        if (checksum == null) {
            throw new NullPointerException("OFBsnGentableClearRequestVer13: property checksum cannot be null");
        }
        if (checksumMask == null) {
            throw new NullPointerException("OFBsnGentableClearRequestVer13: property checksumMask cannot be null");
        }
        this.xid = xid;
        this.tableId = tableId;
        this.checksum = checksum;
        this.checksumMask = checksumMask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 48L;
    }

    @Override
    public GenTableId getTableId() {
        return this.tableId;
    }

    @Override
    public U128 getChecksum() {
        return this.checksum;
    }

    @Override
    public U128 getChecksumMask() {
        return this.checksumMask;
    }

    @Override
    public OFBsnGentableClearRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGentableClearRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("checksum=").append(this.checksum);
        b.append(", ");
        b.append("checksumMask=").append(this.checksumMask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableClearRequestVer13 other = (OFBsnGentableClearRequestVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum)) {
            return false;
        }
        return !(this.checksumMask == null ? other.checksumMask != null : !this.checksumMask.equals(other.checksumMask));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableClearRequestVer13 other = (OFBsnGentableClearRequestVer13)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum)) {
            return false;
        }
        return !(this.checksumMask == null ? other.checksumMask != null : !this.checksumMask.equals(other.checksumMask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        result = 31 * result + (this.checksumMask == null ? 0 : this.checksumMask.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        result = 31 * result + (this.checksumMask == null ? 0 : this.checksumMask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGentableClearRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGentableClearRequestVer13 message) {
            bb.writeByte(4);
            bb.writeByte(4);
            bb.writeShort(52);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(48);
            message.tableId.write2Bytes(bb);
            bb.writeZero(2);
            message.checksum.write16Bytes(bb);
            message.checksumMask.write16Bytes(bb);
        }
    }

    static class OFBsnGentableClearRequestVer13Funnel
    implements Funnel<OFBsnGentableClearRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnGentableClearRequestVer13Funnel() {
        }

        public void funnel(OFBsnGentableClearRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putShort((short)52);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(48);
            message.tableId.putTo(sink);
            message.checksum.putTo(sink);
            message.checksumMask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGentableClearRequest> {
        Reader() {
        }

        @Override
        public OFBsnGentableClearRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 52) {
                throw new OFParseError("Wrong length: Expected=52(52), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 48) {
                throw new OFParseError("Wrong subtype: Expected=0x30L(0x30L), got=" + subtype);
            }
            GenTableId tableId = GenTableId.read2Bytes(bb);
            bb.skipBytes(2);
            U128 checksum = U128.read16Bytes(bb);
            U128 checksumMask = U128.read16Bytes(bb);
            OFBsnGentableClearRequestVer13 bsnGentableClearRequestVer13 = new OFBsnGentableClearRequestVer13(xid, tableId, checksum, checksumMask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGentableClearRequestVer13);
            }
            return bsnGentableClearRequestVer13;
        }
    }

    static class Builder
    implements OFBsnGentableClearRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean checksumSet;
        private U128 checksum;
        private boolean checksumMaskSet;
        private U128 checksumMask;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGentableClearRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 48L;
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableClearRequest.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnGentableClearRequest.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public U128 getChecksumMask() {
            return this.checksumMask;
        }

        @Override
        public OFBsnGentableClearRequest.Builder setChecksumMask(U128 checksumMask) {
            this.checksumMask = checksumMask;
            this.checksumMaskSet = true;
            return this;
        }

        @Override
        public OFBsnGentableClearRequest build() {
            U128 checksumMask;
            U128 checksum;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.tableIdSet) {
                throw new IllegalStateException("Property tableId doesn't have default value -- must be set");
            }
            if (this.tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            U128 u128 = checksum = this.checksumSet ? this.checksum : DEFAULT_CHECKSUM;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            U128 u1282 = checksumMask = this.checksumMaskSet ? this.checksumMask : DEFAULT_CHECKSUM_MASK;
            if (checksumMask == null) {
                throw new NullPointerException("Property checksumMask must not be null");
            }
            return new OFBsnGentableClearRequestVer13(xid, this.tableId, checksum, checksumMask);
        }
    }

    static class BuilderWithParent
    implements OFBsnGentableClearRequest.Builder {
        final OFBsnGentableClearRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean checksumSet;
        private U128 checksum;
        private boolean checksumMaskSet;
        private U128 checksumMask;

        BuilderWithParent(OFBsnGentableClearRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGentableClearRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 48L;
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableClearRequest.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnGentableClearRequest.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public U128 getChecksumMask() {
            return this.checksumMask;
        }

        @Override
        public OFBsnGentableClearRequest.Builder setChecksumMask(U128 checksumMask) {
            this.checksumMask = checksumMask;
            this.checksumMaskSet = true;
            return this;
        }

        @Override
        public OFBsnGentableClearRequest build() {
            U128 checksumMask;
            U128 checksum;
            GenTableId tableId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            GenTableId genTableId = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            U128 u128 = checksum = this.checksumSet ? this.checksum : this.parentMessage.checksum;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            U128 u1282 = checksumMask = this.checksumMaskSet ? this.checksumMask : this.parentMessage.checksumMask;
            if (checksumMask == null) {
                throw new NullPointerException("Property checksumMask must not be null");
            }
            return new OFBsnGentableClearRequestVer13(xid, tableId, checksum, checksumMask);
        }
    }
}

