/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionPopPbb;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionPopPbbVer13
implements OFActionPopPbb {
    private static final Logger logger = LoggerFactory.getLogger(OFActionPopPbbVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    static final OFActionPopPbbVer13 DEFAULT = new OFActionPopPbbVer13();
    static final OFActionPopPbbVer13 INSTANCE = new OFActionPopPbbVer13();
    static final Reader READER = new Reader();
    static final OFActionPopPbbVer13Funnel FUNNEL = new OFActionPopPbbVer13Funnel();
    static final Writer WRITER = new Writer();

    private OFActionPopPbbVer13() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.POP_PBB;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionPopPbb.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionPopPbbVer13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionPopPbbVer13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionPopPbbVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionPopPbbVer13 message) {
            bb.writeShort(27);
            bb.writeShort(8);
            bb.writeZero(4);
        }
    }

    static class OFActionPopPbbVer13Funnel
    implements Funnel<OFActionPopPbbVer13> {
        private static final long serialVersionUID = 1L;

        OFActionPopPbbVer13Funnel() {
        }

        public void funnel(OFActionPopPbbVer13 message, PrimitiveSink sink) {
            sink.putShort((short)27);
            sink.putShort((short)8);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionPopPbb> {
        Reader() {
        }

        @Override
        public OFActionPopPbb readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 27) {
                throw new OFParseError("Wrong type: Expected=OFActionType.POP_PBB(27), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

