/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionBsnChecksum;
import org.projectfloodlight.openflow.types.U128;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionBsnChecksumVer13
implements OFActionBsnChecksum {
    private static final Logger logger = LoggerFactory.getLogger(OFActionBsnChecksumVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 28;
    private static final U128 DEFAULT_CHECKSUM = U128.ZERO;
    private final U128 checksum;
    static final OFActionBsnChecksumVer13 DEFAULT = new OFActionBsnChecksumVer13(DEFAULT_CHECKSUM);
    static final Reader READER = new Reader();
    static final OFActionBsnChecksumVer13Funnel FUNNEL = new OFActionBsnChecksumVer13Funnel();
    static final Writer WRITER = new Writer();

    OFActionBsnChecksumVer13(U128 checksum) {
        if (checksum == null) {
            throw new NullPointerException("OFActionBsnChecksumVer13: property checksum cannot be null");
        }
        this.checksum = checksum;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 4L;
    }

    @Override
    public U128 getChecksum() {
        return this.checksum;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionBsnChecksum.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionBsnChecksumVer13(");
        b.append("checksum=").append(this.checksum);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionBsnChecksumVer13 other = (OFActionBsnChecksumVer13)obj;
        return !(this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionBsnChecksumVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionBsnChecksumVer13 message) {
            bb.writeShort(-1);
            bb.writeShort(28);
            bb.writeInt(6035143);
            bb.writeInt(4);
            message.checksum.write16Bytes(bb);
        }
    }

    static class OFActionBsnChecksumVer13Funnel
    implements Funnel<OFActionBsnChecksumVer13> {
        private static final long serialVersionUID = 1L;

        OFActionBsnChecksumVer13Funnel() {
        }

        public void funnel(OFActionBsnChecksumVer13 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)28);
            sink.putInt(6035143);
            sink.putInt(4);
            message.checksum.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionBsnChecksum> {
        Reader() {
        }

        @Override
        public OFActionBsnChecksum readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 28) {
                throw new OFParseError("Wrong length: Expected=28(28), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 4) {
                throw new OFParseError("Wrong subtype: Expected=0x4L(0x4L), got=" + subtype);
            }
            U128 checksum = U128.read16Bytes(bb);
            OFActionBsnChecksumVer13 actionBsnChecksumVer13 = new OFActionBsnChecksumVer13(checksum);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionBsnChecksumVer13);
            }
            return actionBsnChecksumVer13;
        }
    }

    static class Builder
    implements OFActionBsnChecksum.Builder {
        private boolean checksumSet;
        private U128 checksum;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 4L;
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFActionBsnChecksum.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFActionBsnChecksum build() {
            U128 checksum;
            U128 u128 = checksum = this.checksumSet ? this.checksum : DEFAULT_CHECKSUM;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            return new OFActionBsnChecksumVer13(checksum);
        }
    }

    static class BuilderWithParent
    implements OFActionBsnChecksum.Builder {
        final OFActionBsnChecksumVer13 parentMessage;
        private boolean checksumSet;
        private U128 checksum;

        BuilderWithParent(OFActionBsnChecksumVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 4L;
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFActionBsnChecksum.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFActionBsnChecksum build() {
            U128 checksum;
            U128 u128 = checksum = this.checksumSet ? this.checksum : this.parentMessage.checksum;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            return new OFActionBsnChecksumVer13(checksum);
        }
    }
}

