/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPduRxTimeout;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnPduRxTimeoutVer11
implements OFBsnPduRxTimeout {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnPduRxTimeoutVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 21;
    private static final long DEFAULT_XID = 0L;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final short DEFAULT_SLOT_NUM = 0;
    private final long xid;
    private final OFPort portNo;
    private final short slotNum;
    static final OFBsnPduRxTimeoutVer11 DEFAULT = new OFBsnPduRxTimeoutVer11(0L, DEFAULT_PORT_NO, 0);
    static final Reader READER = new Reader();
    static final OFBsnPduRxTimeoutVer11Funnel FUNNEL = new OFBsnPduRxTimeoutVer11Funnel();
    static final Writer WRITER = new Writer();

    OFBsnPduRxTimeoutVer11(long xid, OFPort portNo, short slotNum) {
        if (portNo == null) {
            throw new NullPointerException("OFBsnPduRxTimeoutVer11: property portNo cannot be null");
        }
        this.xid = xid;
        this.portNo = portNo;
        this.slotNum = slotNum;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 35L;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public short getSlotNum() {
        return this.slotNum;
    }

    @Override
    public OFBsnPduRxTimeout.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnPduRxTimeoutVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("slotNum=").append(this.slotNum);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnPduRxTimeoutVer11 other = (OFBsnPduRxTimeoutVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        return this.slotNum == other.slotNum;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnPduRxTimeoutVer11 other = (OFBsnPduRxTimeoutVer11)obj;
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        return this.slotNum == other.slotNum;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + this.slotNum;
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + this.slotNum;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnPduRxTimeoutVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnPduRxTimeoutVer11 message) {
            bb.writeByte(2);
            bb.writeByte(4);
            bb.writeShort(21);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(35);
            message.portNo.write4Bytes(bb);
            bb.writeByte((int)U8.t(message.slotNum));
        }
    }

    static class OFBsnPduRxTimeoutVer11Funnel
    implements Funnel<OFBsnPduRxTimeoutVer11> {
        private static final long serialVersionUID = 1L;

        OFBsnPduRxTimeoutVer11Funnel() {
        }

        public void funnel(OFBsnPduRxTimeoutVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)4);
            sink.putShort((short)21);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(35);
            message.portNo.putTo(sink);
            sink.putShort(message.slotNum);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnPduRxTimeout> {
        Reader() {
        }

        @Override
        public OFBsnPduRxTimeout readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 21) {
                throw new OFParseError("Wrong length: Expected=21(21), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 35) {
                throw new OFParseError("Wrong subtype: Expected=0x23L(0x23L), got=" + subtype);
            }
            OFPort portNo = OFPort.read4Bytes(bb);
            short slotNum = U8.f(bb.readByte());
            OFBsnPduRxTimeoutVer11 bsnPduRxTimeoutVer11 = new OFBsnPduRxTimeoutVer11(xid, portNo, slotNum);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnPduRxTimeoutVer11);
            }
            return bsnPduRxTimeoutVer11;
        }
    }

    static class Builder
    implements OFBsnPduRxTimeout.Builder {
        private boolean xidSet;
        private long xid;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean slotNumSet;
        private short slotNum;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnPduRxTimeout.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 35L;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnPduRxTimeout.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public short getSlotNum() {
            return this.slotNum;
        }

        @Override
        public OFBsnPduRxTimeout.Builder setSlotNum(short slotNum) {
            this.slotNum = slotNum;
            this.slotNumSet = true;
            return this;
        }

        @Override
        public OFBsnPduRxTimeout build() {
            OFPort portNo;
            long xid = this.xidSet ? this.xid : 0L;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            short slotNum = this.slotNumSet ? this.slotNum : (short)0;
            return new OFBsnPduRxTimeoutVer11(xid, portNo, slotNum);
        }
    }

    static class BuilderWithParent
    implements OFBsnPduRxTimeout.Builder {
        final OFBsnPduRxTimeoutVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean slotNumSet;
        private short slotNum;

        BuilderWithParent(OFBsnPduRxTimeoutVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnPduRxTimeout.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 35L;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnPduRxTimeout.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public short getSlotNum() {
            return this.slotNum;
        }

        @Override
        public OFBsnPduRxTimeout.Builder setSlotNum(short slotNum) {
            this.slotNum = slotNum;
            this.slotNumSet = true;
            return this;
        }

        @Override
        public OFBsnPduRxTimeout build() {
            OFPort portNo;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            short slotNum = this.slotNumSet ? this.slotNum : this.parentMessage.slotNum;
            return new OFBsnPduRxTimeoutVer11(xid, portNo, slotNum);
        }
    }
}

