/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnSetIpMask;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnSetIpMaskVer10
implements OFBsnSetIpMask {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnSetIpMaskVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final short DEFAULT_INDEX = 0;
    private static final long DEFAULT_MASK = 0L;
    private final long xid;
    private final short index;
    private final long mask;
    static final OFBsnSetIpMaskVer10 DEFAULT = new OFBsnSetIpMaskVer10(0L, 0, 0L);
    static final Reader READER = new Reader();
    static final OFBsnSetIpMaskVer10Funnel FUNNEL = new OFBsnSetIpMaskVer10Funnel();
    static final Writer WRITER = new Writer();

    OFBsnSetIpMaskVer10(long xid, short index, long mask) {
        this.xid = xid;
        this.index = index;
        this.mask = mask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 0L;
    }

    @Override
    public short getIndex() {
        return this.index;
    }

    @Override
    public long getMask() {
        return this.mask;
    }

    @Override
    public OFBsnSetIpMask.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnSetIpMaskVer10(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("index=").append(this.index);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSetIpMaskVer10 other = (OFBsnSetIpMaskVer10)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        return this.mask == other.mask;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSetIpMaskVer10 other = (OFBsnSetIpMaskVer10)obj;
        if (this.index != other.index) {
            return false;
        }
        return this.mask == other.mask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + this.index;
        result = 31 * (int)(this.mask ^ this.mask >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.index;
        result = 31 * (int)(this.mask ^ this.mask >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnSetIpMaskVer10> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnSetIpMaskVer10 message) {
            bb.writeByte(1);
            bb.writeByte(4);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(0);
            bb.writeByte((int)U8.t(message.index));
            bb.writeZero(3);
            bb.writeInt(U32.t(message.mask));
        }
    }

    static class OFBsnSetIpMaskVer10Funnel
    implements Funnel<OFBsnSetIpMaskVer10> {
        private static final long serialVersionUID = 1L;

        OFBsnSetIpMaskVer10Funnel() {
        }

        public void funnel(OFBsnSetIpMaskVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)4);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(0);
            sink.putShort(message.index);
            sink.putLong(message.mask);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnSetIpMask> {
        Reader() {
        }

        @Override
        public OFBsnSetIpMask readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 0) {
                throw new OFParseError("Wrong subtype: Expected=0x0L(0x0L), got=" + subtype);
            }
            short index = U8.f(bb.readByte());
            bb.skipBytes(3);
            long mask = U32.f(bb.readInt());
            OFBsnSetIpMaskVer10 bsnSetIpMaskVer10 = new OFBsnSetIpMaskVer10(xid, index, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnSetIpMaskVer10);
            }
            return bsnSetIpMaskVer10;
        }
    }

    static class Builder
    implements OFBsnSetIpMask.Builder {
        private boolean xidSet;
        private long xid;
        private boolean indexSet;
        private short index;
        private boolean maskSet;
        private long mask;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSetIpMask.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 0L;
        }

        @Override
        public short getIndex() {
            return this.index;
        }

        @Override
        public OFBsnSetIpMask.Builder setIndex(short index) {
            this.index = index;
            this.indexSet = true;
            return this;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFBsnSetIpMask.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFBsnSetIpMask build() {
            long xid = this.xidSet ? this.xid : 0L;
            short index = this.indexSet ? this.index : (short)0;
            long mask = this.maskSet ? this.mask : 0L;
            return new OFBsnSetIpMaskVer10(xid, index, mask);
        }
    }

    static class BuilderWithParent
    implements OFBsnSetIpMask.Builder {
        final OFBsnSetIpMaskVer10 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean indexSet;
        private short index;
        private boolean maskSet;
        private long mask;

        BuilderWithParent(OFBsnSetIpMaskVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSetIpMask.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 0L;
        }

        @Override
        public short getIndex() {
            return this.index;
        }

        @Override
        public OFBsnSetIpMask.Builder setIndex(short index) {
            this.index = index;
            this.indexSet = true;
            return this;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFBsnSetIpMask.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFBsnSetIpMask build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            short index = this.indexSet ? this.index : this.parentMessage.index;
            long mask = this.maskSet ? this.mask : this.parentMessage.mask;
            return new OFBsnSetIpMaskVer10(xid, index, mask);
        }
    }
}

