/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHeader;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnBwClearDataReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnBwClearDataRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnBwEnableGetReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnBwEnableGetRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnBwEnableSetReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnBwEnableSetRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnGetInterfacesReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnGetInterfacesRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnGetIpMaskReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnGetIpMaskRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnGetL2TableReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnGetL2TableRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnGetMirroringReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnGetMirroringRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnHybridGetReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnHybridGetRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnPduRxReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnPduRxRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnPduRxTimeoutVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnPduTxReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnPduTxRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnSetIpMaskVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnSetL2TableReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnSetL2TableRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnSetMirroringVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnSetPktinSuppressionReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnSetPktinSuppressionRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnShellCommandVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnShellOutputVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnShellStatusVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnVirtualPortCreateReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnVirtualPortCreateRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnVirtualPortRemoveReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnVirtualPortRemoveRequestVer10;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFBsnHeaderVer10 {
    static final byte WIRE_VERSION = 1;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFBsnHeaderVer10() {
    }

    static class Reader
    implements OFMessageReader<OFBsnHeader> {
        Reader() {
        }

        @Override
        public OFBsnHeader readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            bb.readerIndex(start);
            switch (subtype) {
                case 22: {
                    return OFBsnBwClearDataReplyVer10.READER.readFrom(bb);
                }
                case 21: {
                    return OFBsnBwClearDataRequestVer10.READER.readFrom(bb);
                }
                case 20: {
                    return OFBsnBwEnableGetReplyVer10.READER.readFrom(bb);
                }
                case 19: {
                    return OFBsnBwEnableGetRequestVer10.READER.readFrom(bb);
                }
                case 23: {
                    return OFBsnBwEnableSetReplyVer10.READER.readFrom(bb);
                }
                case 18: {
                    return OFBsnBwEnableSetRequestVer10.READER.readFrom(bb);
                }
                case 10: {
                    return OFBsnGetInterfacesReplyVer10.READER.readFrom(bb);
                }
                case 9: {
                    return OFBsnGetInterfacesRequestVer10.READER.readFrom(bb);
                }
                case 2: {
                    return OFBsnGetIpMaskReplyVer10.READER.readFrom(bb);
                }
                case 1: {
                    return OFBsnGetIpMaskRequestVer10.READER.readFrom(bb);
                }
                case 14: {
                    return OFBsnGetL2TableReplyVer10.READER.readFrom(bb);
                }
                case 13: {
                    return OFBsnGetL2TableRequestVer10.READER.readFrom(bb);
                }
                case 5: {
                    return OFBsnGetMirroringReplyVer10.READER.readFrom(bb);
                }
                case 4: {
                    return OFBsnGetMirroringRequestVer10.READER.readFrom(bb);
                }
                case 28: {
                    return OFBsnHybridGetReplyVer10.READER.readFrom(bb);
                }
                case 27: {
                    return OFBsnHybridGetRequestVer10.READER.readFrom(bb);
                }
                case 34: {
                    return OFBsnPduRxReplyVer10.READER.readFrom(bb);
                }
                case 33: {
                    return OFBsnPduRxRequestVer10.READER.readFrom(bb);
                }
                case 35: {
                    return OFBsnPduRxTimeoutVer10.READER.readFrom(bb);
                }
                case 32: {
                    return OFBsnPduTxReplyVer10.READER.readFrom(bb);
                }
                case 31: {
                    return OFBsnPduTxRequestVer10.READER.readFrom(bb);
                }
                case 0: {
                    return OFBsnSetIpMaskVer10.READER.readFrom(bb);
                }
                case 24: {
                    return OFBsnSetL2TableReplyVer10.READER.readFrom(bb);
                }
                case 12: {
                    return OFBsnSetL2TableRequestVer10.READER.readFrom(bb);
                }
                case 3: {
                    return OFBsnSetMirroringVer10.READER.readFrom(bb);
                }
                case 25: {
                    return OFBsnSetPktinSuppressionReplyVer10.READER.readFrom(bb);
                }
                case 11: {
                    return OFBsnSetPktinSuppressionRequestVer10.READER.readFrom(bb);
                }
                case 6: {
                    return OFBsnShellCommandVer10.READER.readFrom(bb);
                }
                case 7: {
                    return OFBsnShellOutputVer10.READER.readFrom(bb);
                }
                case 8: {
                    return OFBsnShellStatusVer10.READER.readFrom(bb);
                }
                case 16: {
                    return OFBsnVirtualPortCreateReplyVer10.READER.readFrom(bb);
                }
                case 15: {
                    return OFBsnVirtualPortCreateRequestVer10.READER.readFrom(bb);
                }
                case 26: {
                    return OFBsnVirtualPortRemoveReplyVer10.READER.readFrom(bb);
                }
                case 17: {
                    return OFBsnVirtualPortRemoveRequestVer10.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator subtype of class OFBsnHeaderVer10: " + subtype);
        }
    }
}

