/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.Writeable;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.match.MatchFields;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.PrimitiveSinkable;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFOxmList
implements Iterable<OFOxm<?>>,
Writeable,
PrimitiveSinkable {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmList.class);
    private final Map<MatchFields, OFOxm<?>> oxmMap;
    public static final OFOxmList EMPTY = new OFOxmList((Map<MatchFields, OFOxm<?>>)ImmutableMap.of());

    private OFOxmList(Map<MatchFields, OFOxm<?>> oxmMap) {
        this.oxmMap = oxmMap;
    }

    public <T extends OFValueType<T>> OFOxm<T> get(MatchField<T> matchField) {
        return this.oxmMap.get((Object)matchField.id);
    }

    @Override
    public Iterator<OFOxm<?>> iterator() {
        return this.oxmMap.values().iterator();
    }

    public static OFOxmList ofList(Iterable<OFOxm<?>> oxmList) {
        EnumMap map = new EnumMap(MatchFields.class);
        for (OFOxm<?> o : oxmList) {
            OFOxm<?> canonical = o.getCanonical();
            if (logger.isDebugEnabled() && !Objects.equal(o, canonical)) {
                logger.debug("OFOxmList: normalized non-canonical OXM {} to {}", o, canonical);
            }
            if (canonical == null) continue;
            map.put(canonical.getMatchField().id, canonical);
        }
        return new OFOxmList(map);
    }

    public static OFOxmList of(OFOxm<?> ... oxms) {
        EnumMap map = new EnumMap(MatchFields.class);
        for (OFOxm<?> o : oxms) {
            OFOxm<?> canonical = o.getCanonical();
            if (logger.isDebugEnabled() && !Objects.equal(o, canonical)) {
                logger.debug("OFOxmList: normalized non-canonical OXM {} to {}", o, canonical);
            }
            if (canonical == null) continue;
            map.put(canonical.getMatchField().id, canonical);
        }
        return new OFOxmList(map);
    }

    public static OFOxmList readFrom(ByteBuf bb, int length, OFMessageReader<OFOxm<?>> reader) throws OFParseError {
        return OFOxmList.ofList(ChannelUtils.readList(bb, length, reader));
    }

    @Override
    public void writeTo(ByteBuf bb) {
        for (OFOxm<?> o : this) {
            o.writeTo(bb);
        }
    }

    public Builder createBuilder() {
        return new Builder(new EnumMap(this.oxmMap));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.oxmMap == null ? 0 : this.oxmMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmList other = (OFOxmList)obj;
        return !(this.oxmMap == null ? other.oxmMap != null : !this.oxmMap.equals(other.oxmMap));
    }

    public String toString() {
        return "OFOxmList" + this.oxmMap;
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        for (OFOxm<?> o : this) {
            o.putTo(sink);
        }
    }

    public static class Builder {
        private final Map<MatchFields, OFOxm<?>> oxmMap;

        public Builder() {
            this.oxmMap = new EnumMap(MatchFields.class);
        }

        public Builder(EnumMap<MatchFields, OFOxm<?>> oxmMap) {
            this.oxmMap = oxmMap;
        }

        public <T extends OFValueType<T>> void set(OFOxm<T> oxm) {
            this.oxmMap.put(oxm.getMatchField().id, oxm);
        }

        public <T extends OFValueType<T>> void unset(MatchField<T> matchField) {
            this.oxmMap.remove((Object)matchField.id);
        }

        public OFOxmList build() {
            return OFOxmList.ofList(this.oxmMap.values());
        }
    }
}

