/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.primefaces.selenium.PrimeExpectedConditions;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractInputComponent;
import org.primefaces.selenium.internal.ConfigProvider;
import org.primefaces.selenium.spi.WebDriverProvider;

public abstract class FileUpload
extends AbstractInputComponent {
    @Override
    public WebElement getInput() {
        boolean isInputFile = "input".equals(this.getTagName()) && "file".equals(this.getAttribute("type"));
        return isInputFile ? this : this.findElement(By.id((String)(this.getId() + "_input")));
    }

    public String getValue() {
        return this.getInput().getAttribute("value");
    }

    public void setValue(Serializable value) {
        if (this.getInput() != this && !PrimeSelenium.isChrome()) {
            this.getInput().clear();
        }
        this.getInput().sendKeys(new CharSequence[]{value.toString()});
    }

    public void setValue(File ... values) {
        String paths = Arrays.stream(values).map(f -> f.getAbsolutePath()).collect(Collectors.joining("\n"));
        this.setValue((Serializable)((Object)paths));
    }

    public WebElement getAdvancedUploadButton() {
        return this.findElement(By.cssSelector((String)".ui-fileupload-buttonbar button.ui-fileupload-upload"));
    }

    public WebElement getAdvancedCancelButton() {
        return this.findElement(By.cssSelector((String)".ui-fileupload-buttonbar button.ui-fileupload-cancel"));
    }

    public WebElement getAdvancedCancelButton(String fileName) {
        for (WebElement row : this.findElements(By.cssSelector((String)".ui-fileupload-files .ui-fileupload-row"))) {
            WebElement fn = row.findElement(By.cssSelector((String)".ui-fileupload-filename"));
            if (!fn.getText().contains(fileName)) continue;
            return row.findElement(By.cssSelector((String)"button.ui-fileupload-cancel"));
        }
        throw new NoSuchElementException("cancel button for " + fileName + " not found");
    }

    public void waitAdvancedUntilAllFilesAreUploaded(WebElement additionalElementToWaitFor) {
        ConfigProvider config = ConfigProvider.getInstance();
        WebDriver driver = WebDriverProvider.get();
        WebDriverWait wait = new WebDriverWait(driver, (long)config.getTimeoutAjax(), 100L);
        String jsScript = "if (" + this.getWidgetByIdScript() + ".files.length === 0) return true;";
        wait.until((Function)ExpectedConditions.jsReturnsValue((String)jsScript));
        PrimeSelenium.guardAjax((Object)((Object)this));
        PrimeSelenium.wait((int)200);
        PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.visibleAndAnimationComplete((WebElement)additionalElementToWaitFor));
    }

    public String getWidgetValue() {
        return this.findElement(By.className((String)"ui-fileupload-filename")).getText();
    }

    public List<String> getWidgetValues() {
        return this.findElements(By.className((String)"ui-fileupload-filename")).stream().map(e -> e.getText()).collect(Collectors.toList());
    }

    public List<String> getWidgetErrorMessages() {
        return this.findElements(By.className((String)"ui-messages-error-summary")).stream().map(e -> e.getText()).collect(Collectors.toList());
    }
}

