/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.selenium.component.base;

import org.openqa.selenium.WebElement;
import org.primefaces.extensions.selenium.PrimeSelenium;

public class ComponentUtils {
    public static boolean hasAjaxBehavior(WebElement element, String behavior) {
        if (!ComponentUtils.hasBehavior(element, behavior)) {
            return false;
        }
        String id = element.getAttribute("id");
        String result = (String)PrimeSelenium.executeScript((String)("return " + ComponentUtils.getWidgetByIdScript(id) + ".getBehavior('" + behavior + "').toString();"), (Object[])new Object[0]);
        return ComponentUtils.isAjaxScript(result);
    }

    public static boolean hasBehavior(WebElement element, String behavior) {
        if (!ComponentUtils.isWidget(element)) {
            return false;
        }
        String id = element.getAttribute("id");
        return (Boolean)PrimeSelenium.executeScript((String)("return " + ComponentUtils.getWidgetByIdScript(id) + ".hasBehavior('" + behavior + "');"), (Object[])new Object[0]);
    }

    public static boolean isWidget(WebElement element) {
        String id = element.getAttribute("id");
        if (id == null || id.isEmpty()) {
            return false;
        }
        return (Boolean)PrimeSelenium.executeScript((String)("return " + ComponentUtils.getWidgetByIdScript(id) + " != null;"), (Object[])new Object[0]);
    }

    public static boolean isAjaxScript(String script) {
        if (script == null || script.isEmpty()) {
            return false;
        }
        return script.contains("PrimeFaces.ab(") || script.contains("pf.ab(") || script.contains("mojarra.ab(") || script.contains("jsf.ajax.request");
    }

    public static String getWidgetConfiguration(WebElement element) {
        String id = element.getAttribute("id");
        return (String)PrimeSelenium.executeScript((String)("return JSON.stringify(" + ComponentUtils.getWidgetByIdScript(id) + ".cfg);"), (Object[])new Object[0]);
    }

    public static String getWidgetByIdScript(String id) {
        return "PrimeFaces.getWidgetById('" + id + "')";
    }
}

