/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.selenium.component;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.extensions.selenium.PrimeExpectedConditions;
import org.primefaces.extensions.selenium.PrimeSelenium;
import org.primefaces.extensions.selenium.component.base.AbstractInputComponent;
import org.primefaces.extensions.selenium.component.base.ComponentUtils;
import org.primefaces.extensions.selenium.findby.FindByParentPartialId;

public abstract class SelectOneMenu
extends AbstractInputComponent {
    @FindByParentPartialId(value="_label")
    private WebElement label;
    @FindByParentPartialId(value="_items", searchFromRoot=true)
    private WebElement items;
    @FindByParentPartialId(value="_input")
    private WebElement input;
    @FindByParentPartialId(value="_panel", searchFromRoot=true)
    private WebElement panel;

    public void toggleDropdown() {
        if (this.getPanel().isDisplayed()) {
            this.getLabel().click();
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.invisibleAndAnimationComplete((WebElement)this.panel));
        } else {
            PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".show();"), (Object[])new Object[0]);
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.visibleAndAnimationComplete((WebElement)this.panel));
        }
    }

    public void deselect(String label) {
        if (!this.isSelected(label)) {
            return;
        }
        if (!this.getPanel().isDisplayed()) {
            this.toggleDropdown();
        }
        for (WebElement element : this.getItems().findElements(By.tagName((String)"li"))) {
            if (!element.getText().equalsIgnoreCase(label)) continue;
            this.click(element);
            break;
        }
        if (this.getPanel().isDisplayed()) {
            this.toggleDropdown();
        }
    }

    public void select(String label) {
        if (this.isSelected(label)) {
            return;
        }
        if (!this.getPanel().isDisplayed()) {
            this.toggleDropdown();
        }
        for (WebElement element : this.getItems().findElements(By.tagName((String)"li"))) {
            if (!element.getText().equalsIgnoreCase(label)) continue;
            this.click(element);
            break;
        }
        if (this.getPanel().isDisplayed()) {
            this.toggleDropdown();
        }
    }

    public String getSelectedLabel() {
        return this.label.getText();
    }

    public boolean isSelected(String label) {
        return this.getSelectedLabel().equalsIgnoreCase(label);
    }

    public List<String> getLabels() {
        return this.getInput().findElements(By.tagName((String)"option")).stream().map(e -> e.getAttribute("innerHTML")).collect(Collectors.toList());
    }

    public void select(int index) {
        if (this.isSelected(index)) {
            return;
        }
        this.select(this.getLabel(index));
    }

    public void deselect(int index) {
        if (!this.isSelected(index)) {
            return;
        }
        this.deselect(this.getLabel(index));
    }

    public boolean isSelected(int index) {
        return this.getLabel(index).equals(this.getSelectedLabel());
    }

    public String getLabel(int index) {
        return this.getLabels().get(index);
    }

    @Override
    public WebElement getInput() {
        return this.input;
    }

    public WebElement getLabel() {
        return this.label;
    }

    public WebElement getItems() {
        return this.items;
    }

    public WebElement getPanel() {
        return this.panel;
    }

    protected void click(WebElement element) {
        if (ComponentUtils.isAjaxScript(this.input.getAttribute("onchange"))) {
            ((WebElement)PrimeSelenium.guardAjax((Object)element)).click();
        } else {
            element.click();
        }
    }
}

