/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.selenium.component;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.primefaces.extensions.selenium.PrimeExpectedConditions;
import org.primefaces.extensions.selenium.PrimeSelenium;
import org.primefaces.extensions.selenium.component.base.AbstractComponent;
import org.primefaces.extensions.selenium.component.base.ComponentUtils;
import org.primefaces.extensions.selenium.component.model.SelectItem;

public abstract class SelectManyCheckbox
extends AbstractComponent {
    @FindBy(css=".ui-chkbox")
    private List<WebElement> checkboxes;

    public List<WebElement> getCheckboxes() {
        return this.checkboxes;
    }

    public void toggle(int ... indexes) {
        for (int i : indexes) {
            WebElement checkbox = this.getCheckboxes().get(i);
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.visibleAndAnimationComplete((WebElement)checkbox));
            WebElement input = checkbox.findElement(By.tagName((String)"input"));
            if (ComponentUtils.isAjaxScript(input.getAttribute("onchange"))) {
                ((WebElement)PrimeSelenium.guardAjax((Object)checkbox)).click();
                continue;
            }
            checkbox.click();
        }
    }

    public void toggleAll() {
        int i = 0;
        while (i < this.getItemsSize()) {
            this.toggle(i++);
        }
    }

    public void select(int ... indexes) {
        this.deselectAll();
        for (int i : indexes) {
            if (this.isSelected(i)) continue;
            this.toggle(i);
        }
    }

    public void selectAll() {
        for (int i = 0; i < this.getItemsSize(); ++i) {
            if (this.isSelected(i)) continue;
            this.toggle(i);
        }
    }

    public void deselect(int ... indexes) {
        for (int i : indexes) {
            if (!this.isSelected(i)) continue;
            this.toggle(i);
        }
    }

    public void deselectAll() {
        for (int i = 0; i < this.getItemsSize(); ++i) {
            if (!this.isSelected(i)) continue;
            this.toggle(i);
        }
    }

    public int getItemsSize() {
        return this.getCheckboxes().size();
    }

    public List<String> getLabels() {
        return this.getCheckboxes().stream().map(WebElement::getText).collect(Collectors.toList());
    }

    public String getLabel(int index) {
        return this.getItems().get(index).getLabel();
    }

    public List<SelectItem> getItems() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        int idx = 0;
        for (WebElement checkbox : this.getCheckboxes()) {
            WebElement input = checkbox.findElement(By.tagName((String)"input"));
            WebElement label = this.getRoot().findElement(By.cssSelector((String)("label[for='" + input.getAttribute("id") + "']")));
            WebElement box = checkbox.findElement(By.className((String)"ui-chkbox-box"));
            SelectItem item = new SelectItem();
            item.setIndex(idx);
            item.setLabel(label.getText());
            item.setValue(input.getAttribute("value"));
            item.setSelected(PrimeSelenium.hasCssClass((WebElement)box, (String)"ui-state-active"));
            items.add(item);
            ++idx;
        }
        return items;
    }

    public boolean isSelected(int index) {
        return this.getItems().get(index).isSelected();
    }
}

