/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.selenium.component;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.primefaces.extensions.selenium.PrimeSelenium;
import org.primefaces.extensions.selenium.component.base.AbstractInputComponent;
import org.primefaces.extensions.selenium.component.base.ComponentUtils;
import org.primefaces.extensions.selenium.findby.FindByParentPartialId;

public abstract class DatePicker
extends AbstractInputComponent {
    @FindByParentPartialId(value="_input")
    private WebElement input;

    @Override
    public WebElement getInput() {
        return this.input;
    }

    public WebElement getPanel() {
        return this.getWebDriver().findElement(By.id((String)(this.getId() + "_panel")));
    }

    public LocalDateTime getValue() {
        Object date = PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate()"), (Object[])new Object[0]);
        if (date == null) {
            return null;
        }
        long timeZoneOffset = (Long)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate().getTimezoneOffset()"), (Object[])new Object[0]);
        String utcTimeString = (String)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate().toUTCString();"), (Object[])new Object[0]);
        return LocalDateTime.parse(utcTimeString, DateTimeFormatter.RFC_1123_DATE_TIME).minusMinutes(timeZoneOffset);
    }

    public LocalDate getValueAsLocalDate() {
        Object date = PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate()"), (Object[])new Object[0]);
        if (date == null) {
            return null;
        }
        String utcTimeString = (String)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate().toUTCString();"), (Object[])new Object[0]);
        return LocalDate.parse(utcTimeString, DateTimeFormatter.RFC_1123_DATE_TIME);
    }

    public void setValue(LocalDate localDate) {
        this.setValue(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public void setValue(LocalDateTime dateTime) {
        int timezoneOffset = (int)this.getTimezoneOffset();
        int timezoneOffsetHours = timezoneOffset / 60;
        int timezoneOffsetMinutes = timezoneOffset % 60;
        ZoneOffset zoneOffset = ZoneOffset.ofHoursMinutes(timezoneOffsetHours, timezoneOffsetMinutes);
        long millis = dateTime.atOffset(zoneOffset).toInstant().toEpochMilli();
        this.setValue(millis);
    }

    public void setValue(long millis) {
        String formattedDate = this.millisAsFormattedDate(millis);
        WebElement input = this.getInput();
        input.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
        input.sendKeys(new CharSequence[]{formattedDate});
        if (ComponentUtils.hasAjaxBehavior(this.getRoot(), "dateSelect")) {
            ((WebElement)PrimeSelenium.guardAjax((Object)input)).sendKeys(new CharSequence[]{Keys.TAB});
        } else {
            input.sendKeys(new CharSequence[]{Keys.TAB});
        }
    }

    public String millisAsFormattedDate(long millis) {
        return (String)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".jq.data().primeDatePicker.formatDateTime(new Date(" + millis + "));"), (Object[])new Object[0]);
    }

    public long getTimezoneOffset() {
        return (Long)PrimeSelenium.executeScript((String)"return new Date().getTimezoneOffset();", (Object[])new Object[0]);
    }
}

