/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.arquillian.extension.findby;

import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.spi.findby.LocationStrategy;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.primefaces.extensions.arquillian.extension.findby.FindByParentPartialId;

public class ByParentPartialId
extends By {
    private final String partialId;
    private final boolean searchFromRoot;

    public ByParentPartialId(String partialId, boolean searchFromRoot) {
        Validate.notNull((Object)partialId, (String)"Cannot find elements when partialId is null!");
        this.partialId = partialId;
        this.searchFromRoot = searchFromRoot;
    }

    public List<WebElement> findElements(SearchContext searchContext) {
        List elements;
        block4: {
            GrapheneContext grapheneContext = this.getGrapheneContext(searchContext);
            try {
                if (searchContext instanceof WebElement) {
                    WebElement parent = (WebElement)searchContext;
                    String parentId = parent.getAttribute("id");
                    if (parentId == null || StringUtils.isBlank((CharSequence)parentId)) {
                        throw new WebDriverException("Id of parent element is null or empty!");
                    }
                    By by = By.id((String)(parentId + this.partialId));
                    elements = this.searchFromRoot ? grapheneContext.getWebDriver(new Class[]{Default.class}).findElements(by) : parent.findElements(by);
                    break block4;
                }
                throw new WebDriverException("Cannot determine the SearchContext you are passing to the findBy/s method! It is not instance of WebDriver nor WebElement! It is: " + searchContext);
            }
            catch (Exception ex) {
                throw new WebDriverException("Can not locate element using partialId " + this.partialId + " Check out whether it is correct!", (Throwable)ex);
            }
        }
        return elements;
    }

    public WebElement findElement(SearchContext context) {
        List<WebElement> elements = this.findElements(context);
        if (elements == null || elements.isEmpty()) {
            throw new NoSuchElementException("Cannot locate element using: " + this.partialId);
        }
        return elements.get(0);
    }

    public String toString() {
        return "ByParentPartialId(value = \"" + this.partialId + "\", searchFromRoot = \"" + this.searchFromRoot + "\")";
    }

    private GrapheneContext getGrapheneContext(SearchContext searchContext) {
        if (searchContext instanceof GrapheneProxyInstance) {
            return ((GrapheneProxyInstance)searchContext).getGrapheneContext();
        }
        return GrapheneContext.lastContext();
    }

    public static class ParentPartialIdLocationStrategy
    implements LocationStrategy {
        public ByParentPartialId fromAnnotation(Annotation annotation) {
            FindByParentPartialId findBy = (FindByParentPartialId)annotation;
            return new ByParentPartialId(findBy.value(), findBy.searchFromRoot());
        }
    }
}

