/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.arquillian.component;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.primefaces.extensions.arquillian.PrimeGraphene;
import org.primefaces.extensions.arquillian.component.base.AbstractInputComponent;
import org.primefaces.extensions.arquillian.extension.findby.FindByParentPartialId;

public abstract class Calendar
extends AbstractInputComponent {
    @FindByParentPartialId(value="_input")
    private GrapheneElement input;

    public LocalDateTime getValue() {
        Object date = PrimeGraphene.executeScript("return " + this.getWidgetByIdScript() + ".getDate()");
        if (date == null) {
            return null;
        }
        long timeZoneOffset = (Long)PrimeGraphene.executeScript("return " + this.getWidgetByIdScript() + ".getDate().getTimezoneOffset()");
        String utcTimeString = (String)PrimeGraphene.executeScript("return " + this.getWidgetByIdScript() + ".getDate().toUTCString();");
        return LocalDateTime.parse(utcTimeString, DateTimeFormatter.RFC_1123_DATE_TIME).minusMinutes(timeZoneOffset);
    }

    public void setValue(LocalDate localDate) {
        this.setValue(localDate.atStartOfDay());
    }

    public void setValue(LocalDateTime dateTime) {
        int timezoneOffset = (int)this.getTimezoneOffset();
        int timezoneOffsetHours = timezoneOffset / 60;
        int timezoneOffsetMinutes = timezoneOffset % 60;
        ZoneOffset zoneOffset = ZoneOffset.ofHoursMinutes(timezoneOffsetHours, timezoneOffsetMinutes);
        long millis = dateTime.atOffset(zoneOffset).toInstant().toEpochMilli();
        this.setValue(millis);
    }

    public void setValue(long millis) {
        String formattedDate = this.millisAsFormattedDate(millis);
        this.getInput().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
        this.getInput().sendKeys(new CharSequence[]{Keys.DELETE});
        this.getInput().sendKeys(new CharSequence[]{formattedDate});
        if (PrimeGraphene.hasAjaxBehavior((WebElement)this.root, "dateSelect")) {
            PrimeGraphene.guardAjaxSilently(this.getInput()).sendKeys(new CharSequence[]{Keys.TAB});
        } else {
            this.getInput().sendKeys(new CharSequence[]{Keys.TAB});
        }
    }

    public String millisAsFormattedDate(long millis) {
        return (String)PrimeGraphene.executeScript("return $.datepicker.formatDate(" + this.getWidgetByIdScript() + ".cfg.dateFormat, new Date(" + millis + "));");
    }

    public long getTimezoneOffset() {
        return (Long)PrimeGraphene.executeScript("return new Date().getTimezoneOffset();");
    }

    public GrapheneElement getInput() {
        return this.input;
    }
}

